/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.collector;

import cn.com.yusys.es.collector.EventDriver;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class EventDriverProxyBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(EventDriverProxyBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        log.info("bean---{}---{}", (Object)beanName, bean.getClass());
        if (bean.getClass().isAnnotationPresent(EventDriver.class)) {
            ProxyFactory factory = new ProxyFactory(bean);
            factory.setProxyTargetClass(true);
            factory.addAdvice((Advice)new EventPublishBeanInterceptor());
            return factory.getProxy();
        }
        return bean;
    }

    private class EventPublishBeanInterceptor
    implements MethodInterceptor {
        private EventPublishBeanInterceptor() {
        }

        public Object invoke(MethodInvocation i) throws Throwable {
            Object ret = null;
            try {
                ret = i.proceed();
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new Throwable(e.getMessage());
            }
            log.info("------method " + i.getMethod() + " is called on " + i.getThis() + " with args " + i.getArguments());
            log.info("------method " + i.getMethod() + " returns " + ret);
            return ret;
        }
    }
}

