/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.utils;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowFlake {
    private static final Logger log = LoggerFactory.getLogger(SnowFlake.class);
    private static final long START_STAMP = 1262275200000L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 10L;
    public static final long MAX_MACHINE_NUM = 1023L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long TIMESTAMP_LEFT = 22L;
    private long machineId;
    private long sequence = 0L;
    private long lastStamp = -1L;

    SnowFlake(long machineId) {
        if (machineId > 1023L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.machineId = machineId;
    }

    public synchronized Long nextId() {
        long currStamp = this.getNewStamp();
        if (currStamp < this.lastStamp) {
            throw new TimeBackwardsException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                this.sequence = new Random().nextInt(10);
                currStamp = this.getNextMill();
            }
        } else {
            this.sequence = new Random().nextInt(10);
        }
        this.lastStamp = currStamp;
        return currStamp - 1262275200000L << 22 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewStamp();
        while (mill <= this.lastStamp) {
            mill = this.getNewStamp();
        }
        return mill;
    }

    private long getNewStamp() {
        return System.currentTimeMillis();
    }

    public static long getId() {
        SnowFlake snowFlake = null;
        if (snowFlake == null) {
            snowFlake = new SnowFlake(1L);
        }
        return snowFlake.nextId();
    }

    private static class TimeBackwardsException
    extends RuntimeException {
        TimeBackwardsException(String message) {
            super(message);
        }
    }
}

