/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.stream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class DLXAutoHandler
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DLXAutoHandler.class);
    private static final String DLQ = "public-destination.dlq";
    private final RabbitTemplate rabbitTemplate;
    private ApplicationContext applicationContext;

    @Autowired
    public DLXAutoHandler(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        log.info("Starting dead letter queue ContextRefreshedEvent--->{}", (Object)event.getApplicationContext());
        if (event.getApplicationContext().equals(this.applicationContext)) {
            Message message = this.rabbitTemplate.receive(DLQ);
            int i = 0;
            while (message != null) {
                this.rabbitTemplate.send(message.getMessageProperties().getReceivedRoutingKey(), message);
                log.debug("succeed send QLX message to {}", (Object)message.getMessageProperties().getReceivedRoutingKey());
                message = this.rabbitTemplate.receive(DLQ);
                ++i;
            }
            log.info("Send {} from DLX", (Object)i);
        }
    }
}

