/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.event;

import cn.com.yusys.es.collector.RestfullCollector;
import cn.com.yusys.es.event.DomainEventEntry;
import cn.com.yusys.es.event.DomainEventEntryRepository;
import cn.com.yusys.es.publisher.DomainEventEntryPublisher;
import java.util.concurrent.CompletableFuture;
import javax.persistence.PostPersist;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
@EnableAsync
public class DomainEventEntryListener {
    private static final Logger log = LoggerFactory.getLogger(DomainEventEntryListener.class);
    static RestfullCollector restfullCollector;
    static DomainEventEntryRepository domainEventEntryRepository;
    static DomainEventEntryPublisher domainEventEntryPublisher;

    @Autowired
    public void init(RestfullCollector restfullCollector, DomainEventEntryRepository domainEventEntryRepository, DomainEventEntryPublisher domainEventEntryPublisher) {
        DomainEventEntryListener.restfullCollector = restfullCollector;
        DomainEventEntryListener.domainEventEntryRepository = domainEventEntryRepository;
        DomainEventEntryListener.domainEventEntryPublisher = domainEventEntryPublisher;
    }

    @PostPersist
    void onPersist(final DomainEventEntry entry) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                if (status == 0) {
                    CompletableFuture.runAsync(() -> DomainEventEntryListener.this.sendEvent(entry));
                }
            }
        });
    }

    @Transactional
    public void sendEvent(DomainEventEntry eventEntry) {
        if (!eventEntry.isSent()) {
            restfullCollector.messageSendStart(eventEntry);
            boolean isSend = domainEventEntryPublisher.sendEvent(eventEntry);
            if (isSend) {
                eventEntry.setSent(true);
                restfullCollector.messageSendEnd(eventEntry);
                domainEventEntryRepository.delete(eventEntry);
            }
        }
    }
}

