/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.collector;

import cn.com.yusys.es.collector.span.MessageSpan;
import cn.com.yusys.es.event.DomainEventEntry;
import cn.com.yusys.es.utils.SnowFlake;
import java.net.Inet4Address;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RestfullCollector {
    private static final Logger log = LoggerFactory.getLogger(RestfullCollector.class);
    @Value(value="${spring.application.name:notProvided}")
    String serviceName;
    String serviceInstance;
    @Value(value="${server.port:8080}")
    private String port;
    @Value(value="${event.trace.url:}")
    private String url;
    RestTemplate restTemplate = new RestTemplate();

    public RestfullCollector() {
        try {
            this.serviceInstance = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            log.error("init serviceInstance error:{}", (Object)e.getMessage());
        }
    }

    public void messageSendStart(DomainEventEntry eventEntry) {
        this.postData(eventEntry, "SendStart");
    }

    public void messageSendEnd(DomainEventEntry eventEntry) {
        this.postData(eventEntry, "SendEnd");
    }

    public void messageReceivedHandleStart(DomainEventEntry eventEntry) {
        this.postData(eventEntry, "HandleStart");
    }

    public void messageReceivedHandleEnd(DomainEventEntry eventEntry) {
        this.postData(eventEntry, "HandleEnd");
    }

    void postData(DomainEventEntry eventEntry, String spanName) {
        CompletableFuture.runAsync(() -> {
            if (StringUtils.isNotEmpty((String)this.url)) {
                MessageSpan span = new MessageSpan(this.serviceName, this.serviceInstance + ":" + this.port, new Date(), eventEntry.getEventType(), eventEntry.getPayload(), eventEntry.getMetaData(), SnowFlake.getId(), spanName);
                try {
                    this.restTemplate.postForEntity(this.url, (Object)span, MessageSpan.class, new Object[0]);
                }
                catch (Exception e) {
                    log.error("event.trace.url error:{}", (Object)e.getMessage());
                }
            }
        });
    }
}

