/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.msg.command.CommandExecutorThread;
import org.jbpm.scheduler.impl.SchedulerThread;

public class JbpmThreadsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    String jbpmConfigurationResource = null;
    String jbpmContextName = null;
    JbpmConfiguration jbpmConfiguration = null;
    CommandExecutorThread commandExecutorThread = null;
    SchedulerThread schedulerThread = null;
    private static Log log = LogFactory.getLog(JbpmThreadsServlet.class);

    public void init() throws ServletException {
        this.jbpmConfigurationResource = this.getInitParameter("jbpm.configuration.resource");
        if (this.jbpmConfigurationResource == null) {
            log.debug((Object)"using default jbpm cfg resource");
        } else {
            log.debug((Object)("using jbpm cfg resource: '" + this.jbpmConfigurationResource + "'"));
        }
        this.jbpmContextName = this.getInitParameter("jbpm.context.name");
        if (this.jbpmContextName == null) {
            log.debug((Object)"using default jbpm context");
            this.jbpmContextName = "default.jbpm.context";
        } else {
            log.debug((Object)("using jbpm context: '" + this.jbpmContextName + "'"));
        }
        int commandExecutorInterval = Integer.parseInt(this.getInitParameter("commandExecutorInterval", "5000"));
        int schedulerInterval = Integer.parseInt(this.getInitParameter("schedulerInterval", "5000"));
        int priority = Integer.parseInt(this.getInitParameter("priority", "1"));
        int maxResultCount = Integer.parseInt(this.getInitParameter("maxResultCount", "1"));
        JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance(this.jbpmConfigurationResource);
        this.commandExecutorThread = new CommandExecutorThread(jbpmConfiguration);
        this.commandExecutorThread.setInterval(commandExecutorInterval);
        this.commandExecutorThread.setPriority(priority);
        this.commandExecutorThread.start();
        this.schedulerThread = new SchedulerThread(jbpmConfiguration);
        this.schedulerThread.setPriority(priority);
        this.schedulerThread.setInterval(schedulerInterval);
        this.schedulerThread.setMaxResultCount(maxResultCount);
        this.schedulerThread.start();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<body>");
        out.println("<h2>JBoss jBPM Threads Servlet</h2><hr />");
        out.println("</body>");
        out.println("</html>");
    }

    protected String getInitParameter(String name, String defaultValue) {
        String value = this.getInitParameter(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void destroy() {
        super.destroy();
        if (this.schedulerThread != null && this.schedulerThread.isAlive()) {
            this.schedulerThread.quit();
        }
        if (this.commandExecutorThread != null && this.commandExecutorThread.isAlive()) {
            this.commandExecutorThread.quit();
        }
    }
}

