/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.web;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;

public class JbpmContextFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 1L;
    String jbpmConfigurationResource = null;
    String jbpmContextName = null;
    boolean isAuthenticationEnabled = true;

    public void init(FilterConfig filterConfig) throws ServletException {
        String isAuthenticationEnabledText;
        this.jbpmConfigurationResource = filterConfig.getInitParameter("jbpm.configuration.resource");
        this.jbpmContextName = filterConfig.getInitParameter("jbpm.context.name");
        if (this.jbpmContextName == null) {
            this.jbpmContextName = "default.jbpm.context";
        }
        if ((isAuthenticationEnabledText = filterConfig.getInitParameter("authentication")) != null && "disabled".equalsIgnoreCase(isAuthenticationEnabledText)) {
            this.isAuthenticationEnabled = false;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        Principal userPrincipal;
        String actorId = null;
        if (servletRequest instanceof HttpServletRequest && (userPrincipal = (httpServletRequest = (HttpServletRequest)servletRequest).getUserPrincipal()) != null) {
            actorId = userPrincipal.getName();
        }
        JbpmContext jbpmContext = this.getJbpmConfiguration().createJbpmContext(this.jbpmContextName);
        try {
            if (this.isAuthenticationEnabled) {
                jbpmContext.setActorId(actorId);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            jbpmContext.close();
        }
    }

    protected JbpmConfiguration getJbpmConfiguration() {
        return JbpmConfiguration.getInstance(this.jbpmConfigurationResource);
    }

    public void destroy() {
    }
}

