/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.VariableContainer;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.security.SecurityHelper;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskController;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.jbpm.taskmgmt.log.TaskAssignLog;
import org.jbpm.taskmgmt.log.TaskEndLog;
import org.jbpm.util.EqualsUtil;

public class TaskInstance
extends VariableContainer
implements Assignable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String name = null;
    protected String description = null;
    protected String actorId = null;
    protected Date create = null;
    protected Date start = null;
    protected Date end = null;
    protected Date dueDate = null;
    protected int priority = 3;
    protected boolean isCancelled = false;
    protected boolean isSuspended = false;
    protected boolean isOpen = true;
    protected boolean isSignalling = true;
    protected boolean isBlocking = false;
    protected Task task = null;
    protected Token token = null;
    protected SwimlaneInstance swimlaneInstance = null;
    protected TaskMgmtInstance taskMgmtInstance = null;
    protected Set pooledActors = null;
    protected List comments = null;
    protected String previousActorId = null;
    private static final Log log = LogFactory.getLog(TaskInstance.class);

    public TaskInstance() {
    }

    public TaskInstance(String taskName) {
        this.name = taskName;
    }

    public TaskInstance(String taskName, String actorId) {
        this.name = taskName;
        this.actorId = actorId;
    }

    public void setTask(Task task) {
        this.name = task.getName();
        this.description = task.getDescription();
        this.task = task;
        this.isBlocking = task.isBlocking();
        this.priority = task.getPriority();
        if (task.getTaskNode() != null) {
            int signal = task.getTaskNode().getSignal();
            boolean bl = this.isSignalling = signal == 2 || signal == 4 || signal == 3 || signal == 5;
        }
        if (task.getDueDate() != null) {
            BusinessCalendar businessCalendar = new BusinessCalendar();
            this.dueDate = businessCalendar.add(new Date(), new Duration(task.getDueDate()));
        }
    }

    void submitVariables() {
        TaskController taskController;
        TaskController taskController2 = taskController = this.task != null ? this.task.getTaskController() : null;
        if (taskController != null) {
            taskController.submitParameters(this);
        } else if (this.token != null && this.token.getProcessInstance() != null && this.variableInstances != null) {
            ContextInstance contextInstance = this.token.getProcessInstance().getContextInstance();
            for (VariableInstance variableInstance : this.variableInstances.values()) {
                log.debug((Object)("flushing variable '" + variableInstance.getName() + "' from task '" + this.name + "' to process variables"));
                contextInstance.setVariable(variableInstance.getName(), variableInstance.getValue(), this.token);
            }
        }
    }

    void initializeVariables() {
        TaskController taskController;
        TaskController taskController2 = taskController = this.task != null ? this.task.getTaskController() : null;
        if (taskController != null) {
            taskController.initializeVariables(this);
        }
    }

    public void create() {
        this.create(null);
    }

    public void create(ExecutionContext executionContext) {
        if (this.create != null) {
            throw new IllegalStateException("task instance '" + this.id + "' was already created");
        }
        this.create = new Date();
        if (this.task != null && executionContext != null) {
            executionContext.setTaskInstance(this);
            executionContext.setTask(this.task);
            this.task.fireEvent("task-create", executionContext);
        }
    }

    public void assign(ExecutionContext executionContext) {
        TaskMgmtInstance taskMgmtInstance = executionContext.getTaskMgmtInstance();
        Swimlane swimlane = this.task.getSwimlane();
        if (swimlane != null) {
            if (this.isStartTaskInstance()) {
                this.swimlaneInstance = new SwimlaneInstance(swimlane);
                taskMgmtInstance.addSwimlaneInstance(this.swimlaneInstance);
                this.swimlaneInstance.setActorId(SecurityHelper.getAuthenticatedActorId());
            } else {
                this.swimlaneInstance = taskMgmtInstance.getInitializedSwimlaneInstance(executionContext, swimlane);
                this.copySwimlaneInstanceAssignment(this.swimlaneInstance);
            }
        } else {
            taskMgmtInstance.performAssignment(this.task.getAssignmentDelegation(), this.task.getActorIdExpression(), this.task.getPooledActorsExpression(), this, executionContext);
        }
        this.updatePooledActorsReferences(this.swimlaneInstance);
    }

    public boolean isStartTaskInstance() {
        boolean isStartTaskInstance = false;
        if (this.taskMgmtInstance != null && this.taskMgmtInstance.getTaskMgmtDefinition() != null) {
            isStartTaskInstance = this.task != null && this.task.equals(this.taskMgmtInstance.getTaskMgmtDefinition().getStartTask());
        }
        return isStartTaskInstance;
    }

    void updatePooledActorsReferences(SwimlaneInstance swimlaneInstance) {
        if (this.pooledActors != null) {
            for (PooledActor pooledActor : this.pooledActors) {
                pooledActor.setSwimlaneInstance(swimlaneInstance);
                pooledActor.addTaskInstance(this);
            }
        }
    }

    public void copySwimlaneInstanceAssignment(SwimlaneInstance swimlaneInstance) {
        this.setSwimlaneInstance(swimlaneInstance);
        this.setActorId(swimlaneInstance.getActorId());
        this.setPooledActors(swimlaneInstance.getPooledActors());
    }

    public Set getPooledActors() {
        if (this.swimlaneInstance != null && (this.pooledActors == null || this.pooledActors.isEmpty())) {
            return this.swimlaneInstance.pooledActors;
        }
        return this.pooledActors;
    }

    @Override
    public void setActorId(String actorId) {
        this.setActorId(actorId, true);
    }

    public void setActorId(String actorId, boolean overwriteSwimlane) {
        this.previousActorId = this.actorId;
        this.actorId = actorId;
        if (this.swimlaneInstance != null && overwriteSwimlane) {
            log.debug((Object)("assigning task '" + this.name + "' to '" + actorId + "'"));
            this.swimlaneInstance.setActorId(actorId);
        }
        if (this.task != null && this.token != null) {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            executionContext.setTask(this.task);
            executionContext.setTaskInstance(this);
            this.task.fireEvent("task-assign", executionContext);
        }
        if (this.token != null) {
            this.token.addLog(new TaskAssignLog(this, this.previousActorId, actorId));
        }
    }

    @Override
    public void setPooledActors(String[] actorIds) {
        this.pooledActors = PooledActor.createPool(actorIds, null, this);
    }

    public void start() {
        if (this.start != null) {
            throw new IllegalStateException("task instance '" + this.id + "' is already started");
        }
        this.start = new Date();
        if (this.task != null && this.token != null) {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            executionContext.setTask(this.task);
            executionContext.setTaskInstance(this);
            this.task.fireEvent("task-start", executionContext);
        }
    }

    public void start(String actorId) {
        this.start(actorId, true);
    }

    public void start(String actorId, boolean overwriteSwimlane) {
        this.setActorId(actorId, overwriteSwimlane);
        this.start();
    }

    public void cancel() {
        this.isCancelled = true;
        this.isOpen = false;
        this.end();
    }

    public void end() {
        this.end((Transition)null);
    }

    public void end(String transitionName) {
        Transition leavingTransition = null;
        if (this.task != null) {
            Node node = this.task.getTaskNode();
            if (node == null) {
                node = (Node)this.task.getParent();
            }
            if (node != null) {
                leavingTransition = node.getLeavingTransition(transitionName);
            }
        }
        if (leavingTransition == null) {
            throw new JbpmException("task node does not have leaving transition '" + transitionName + "'");
        }
        this.end(leavingTransition);
    }

    public void end(Transition transition) {
        if (this.end != null) {
            throw new IllegalStateException("task instance '" + this.id + "' is already ended");
        }
        if (this.isSuspended) {
            throw new JbpmException("task instance '" + this.id + "' is suspended");
        }
        this.end = new Date();
        this.isOpen = false;
        if (this.task != null && this.token != null) {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            executionContext.setTask(this.task);
            executionContext.setTaskInstance(this);
            this.task.fireEvent("task-end", executionContext);
        }
        if (this.token != null) {
            this.token.addLog(new TaskEndLog(this));
        }
        this.submitVariables();
        if (this.isSignalling) {
            this.isSignalling = false;
            if (this.isStartTaskInstance() || this.task != null && this.token != null && this.task.getTaskNode() != null && this.task.getTaskNode().completionTriggersSignal(this)) {
                if (transition == null) {
                    log.debug((Object)("completion of task '" + this.task.getName() + "' results in taking the default transition"));
                    this.token.signal();
                } else {
                    log.debug((Object)("completion of task '" + this.task.getName() + "' results in taking transition '" + transition + "'"));
                    this.token.signal(transition);
                }
            }
        }
    }

    public boolean hasEnded() {
        return this.end != null;
    }

    public void suspend() {
        this.isSuspended = true;
        this.isOpen = false;
    }

    public void resume() {
        this.isSuspended = false;
        this.isOpen = true;
    }

    public void addComment(String message) {
        this.addComment(new Comment(message));
    }

    public void addComment(Comment comment) {
        if (comment != null) {
            if (this.comments == null) {
                this.comments = new ArrayList();
            }
            this.comments.add(comment);
            comment.setTaskInstance(this);
            if (this.token != null) {
                comment.setToken(this.token);
                this.token.addComment(comment);
            }
        }
    }

    public List getComments() {
        return this.comments;
    }

    public boolean isLast() {
        return this.token != null && this.taskMgmtInstance != null && !this.taskMgmtInstance.hasUnfinishedTasks(this.token);
    }

    public List getAvailableTransitions() {
        ArrayList transitions = null;
        if (!this.isLast() && this.token != null) {
            transitions = new ArrayList(this.token.getNode().getLeavingTransitions());
        }
        return transitions;
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String toString() {
        return "TaskInstance" + (this.name != null ? "[" + this.name + "]" : Integer.toHexString(System.identityHashCode(this)));
    }

    public void setPooledActors(Set pooledActors) {
        if (pooledActors != null) {
            this.pooledActors = new HashSet(pooledActors);
            for (PooledActor pooledActor : pooledActors) {
                pooledActor.addTaskInstance(this);
            }
        } else {
            pooledActors = null;
        }
    }

    @Override
    protected VariableContainer getParentVariableContainer() {
        ContextInstance contextInstance = this.getContextInstance();
        return contextInstance != null ? contextInstance.getOrCreateTokenVariableMap(this.token) : null;
    }

    public String getActorId() {
        return this.actorId;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setCreate(Date create) {
        this.create = create;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getStart() {
        return this.start;
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return this.taskMgmtInstance;
    }

    public void setTaskMgmtInstance(TaskMgmtInstance taskMgmtInstance) {
        this.taskMgmtInstance = taskMgmtInstance;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setSignalling(boolean isSignalling) {
        this.isSignalling = isSignalling;
    }

    public boolean isSignalling() {
        return this.isSignalling;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public Date getCreate() {
        return this.create;
    }

    public Task getTask() {
        return this.task;
    }

    public SwimlaneInstance getSwimlaneInstance() {
        return this.swimlaneInstance;
    }

    public void setSwimlaneInstance(SwimlaneInstance swimlaneInstance) {
        this.swimlaneInstance = swimlaneInstance;
    }

    public String getPreviousActorId() {
        return this.previousActorId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

