/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.scheduler.impl.SchedulerListener;

public class SchedulerThread
extends Thread {
    static BusinessCalendar businessCalendar = new BusinessCalendar();
    JbpmConfiguration jbpmConfiguration = null;
    String jbpmContextName = null;
    List listeners = new ArrayList();
    boolean keepRunning = true;
    long interval = 5000L;
    int maxResultCount = 1;
    private static final Log log = LogFactory.getLog(SchedulerThread.class);

    public SchedulerThread() {
        this(JbpmConfiguration.getInstance(), "default.jbpm.context");
    }

    public SchedulerThread(JbpmConfiguration jbpmConfiguration) {
        this(jbpmConfiguration, "default.jbpm.context");
    }

    public SchedulerThread(String jbpmContextName) {
        this(JbpmConfiguration.getInstance(), jbpmContextName);
    }

    public SchedulerThread(JbpmConfiguration jbpmConfiguration, String jbpmContextName) {
        super("JbpmScheduler");
        this.jbpmConfiguration = jbpmConfiguration;
        this.jbpmContextName = jbpmContextName;
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            long millisToWait = this.interval;
            try {
                try {
                    millisToWait = this.executeTimers();
                    if (millisToWait < 0L) {
                        millisToWait = this.interval;
                    }
                    millisToWait = Math.min(millisToWait, this.interval);
                }
                catch (RuntimeException e) {
                    log.info((Object)"runtime exception while executing timers", (Throwable)e);
                    try {
                        Thread.sleep(millisToWait);
                    }
                    catch (InterruptedException e2) {
                        log.info((Object)"waiting for timers got interuppted");
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    Thread.sleep(millisToWait);
                }
                catch (InterruptedException e) {
                    log.info((Object)"waiting for timers got interuppted");
                }
                throw throwable;
            }
            try {
                Thread.sleep(millisToWait);
            }
            catch (InterruptedException e) {
                log.info((Object)"waiting for timers got interuppted");
            }
        }
        log.info((Object)"ending scheduler thread");
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long executeTimers() {
        millisTillNextTimerIsDue = -1L;
        isDueDateInPast = true;
        jbpmContext = this.jbpmConfiguration.createJbpmContext(this.jbpmContextName);
        try {
            schedulerSession = jbpmContext.getSchedulerSession();
            SchedulerThread.log.debug((Object)"checking for timers");
            iter = schedulerSession.findTimersByDueDate(this.maxResultCount);
            if (true) ** GOTO lbl34
            do {
                timer = (Timer)iter.next();
                SchedulerThread.log.debug((Object)("found timer " + timer));
                if (timer.isDue()) {
                    SchedulerThread.log.debug((Object)("executing timer '" + timer + "'"));
                    timer.execute();
                    jbpmContext.save(timer.getProcessInstance());
                    this.notifyListeners(timer);
                    if (timer.getException() != null) {
                        schedulerSession.saveTimer(timer);
                    } else if (timer.getRepeat() != null) {
                        dueDate = timer.getDueDate();
                        while (dueDate.getTime() <= System.currentTimeMillis()) {
                            dueDate = SchedulerThread.businessCalendar.add(dueDate, new Duration(timer.getRepeat()));
                        }
                        timer.setDueDate(dueDate);
                        SchedulerThread.log.debug((Object)("saving updated timer for repetition '" + timer + "' in '" + (dueDate.getTime() - System.currentTimeMillis()) + "' millis"));
                        schedulerSession.saveTimer(timer);
                    } else {
                        SchedulerThread.log.debug((Object)("deleting timer '" + timer + "'"));
                        schedulerSession.deleteTimer(timer);
                    }
                } else {
                    isDueDateInPast = false;
                    millisTillNextTimerIsDue = timer.getDueDate().getTime() - System.currentTimeMillis();
                }
lbl34:
                // 5 sources

                if (!iter.hasNext()) return millisTillNextTimerIsDue;
            } while (isDueDateInPast);
            return millisTillNextTimerIsDue;
        }
        finally {
            jbpmContext.close();
        }
    }

    public void addListener(SchedulerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(SchedulerListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    void notifyListeners(Timer timer) {
        if (this.listeners != null) {
            Date now = new Date();
            for (SchedulerListener timerRunnerListener : new ArrayList(this.listeners)) {
                timerRunnerListener.timerExecuted(now, timer);
            }
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setMaxResultCount(int maxResultCount) {
        this.maxResultCount = maxResultCount;
    }

    public void quit() {
        this.keepRunning = false;
        this.interrupt();
    }
}

