/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.scheduler.impl.Scheduler;
import org.jbpm.scheduler.impl.SchedulerListener;

public class SchedulerMain {
    static DateFormat dateFormat = null;
    static final String NEWLINE = System.getProperty("line.separator");
    private static final Log log = LogFactory.getLog(SchedulerMain.class);

    public static void main(String[] args) {
        Scheduler scheduler = new Scheduler();
        int interval = Integer.parseInt(SchedulerMain.getParameter(args, 0, "5000"));
        scheduler.setInterval(interval);
        int historyMaxSize = Integer.parseInt(SchedulerMain.getParameter(args, 1, "50"));
        scheduler.setHistoryMaxSize(historyMaxSize);
        dateFormat = new SimpleDateFormat(SchedulerMain.getParameter(args, 2, "dd/MM/yyyy HH:mm:ss"));
        scheduler.getSchedulerThread().addListener(new LogListener());
        scheduler.start();
    }

    static String getParameter(String[] args, int index, String defaultValue) {
        String value = null;
        value = args != null && args.length > index ? args[index] : defaultValue;
        return value;
    }

    static class LogListener
    implements SchedulerListener {
        LogListener() {
        }

        @Override
        public void timerExecuted(Date date, Timer timer) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(dateFormat.format(date));
            buffer.append(" | ");
            buffer.append(timer.toString());
            buffer.append(" | ");
            if (timer.getException() == null) {
                buffer.append("OK |");
            } else {
                buffer.append("exception...");
                buffer.append(NEWLINE);
                buffer.append(timer.getException());
                buffer.append(NEWLINE);
            }
            log.info((Object)buffer.toString());
        }
    }
}

