/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.db;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.MessagingSession;
import org.jbpm.graph.exe.Token;
import org.jbpm.msg.Message;
import org.jbpm.msg.MessageService;
import org.jbpm.msg.db.StaticNotifier;

public class DbMessageService
implements MessageService {
    private static final long serialVersionUID = 1L;
    MessagingSession messagingSession = null;
    Collection destinations = null;
    private static Log log = LogFactory.getLog(DbMessageService.class);

    public DbMessageService() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("instantiation of the DbMessageService requires a current JbpmContext");
        }
        this.messagingSession = jbpmContext.getMessagingSession();
    }

    @Override
    public void send(Message message) {
        String destination = message.getDestination();
        if (destination == null) {
            throw new JbpmException("message without destination cannot be sent");
        }
        log.trace((Object)("sending msg '" + message + "' to destination '" + destination + "'"));
        this.messagingSession.save(message);
        this.addDestination(destination);
    }

    @Override
    public void suspendMessages(Token token) {
        this.messagingSession.suspendMessages(token);
    }

    @Override
    public void resumeMessages(Token token) {
        this.messagingSession.resumeMessages(token);
    }

    public boolean hasMessages(String destination) {
        return this.messagingSession.hasNextMessage(destination);
    }

    public Message receiveNoWait(String destination) {
        Message message = this.messagingSession.nextMessage(destination);
        if (message != null) {
            log.trace((Object)("received msg '" + message + "'"));
            this.messagingSession.delete(message);
        }
        return message;
    }

    public Message receiveByIdNoWait(long id) {
        Message message = this.messagingSession.loadMessage(id);
        log.trace((Object)("received msg by id '" + id + "' :" + message));
        if (message != null) {
            this.messagingSession.delete(message);
        }
        return message;
    }

    public MessagingSession getMessagingSession() {
        return this.messagingSession;
    }

    @Override
    public void close() {
        if (this.destinations != null) {
            for (String destination : this.destinations) {
                StaticNotifier.notify(destination);
            }
        }
    }

    void addDestination(String destination) {
        if (this.destinations == null) {
            this.destinations = new ArrayList();
        }
        this.destinations.add(destination);
    }
}

