/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.command;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.db.MessagingSession;
import org.jbpm.msg.Message;
import org.jbpm.msg.db.DbMessageService;

public class CommandExecutorThread
extends Thread
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_COMMAND_EXECUTOR_CONTEXT_NAME = "default.jbpm.context";
    public static final String DEFAULT_ERROR_DESTINATION = "ERROR";
    JbpmConfiguration jbpmConfiguration = null;
    String jbpmContextName = "default.jbpm.context";
    String destination = "CMD_EXECUTOR";
    String errorDestination = "ERROR";
    int interval = 5000;
    boolean keepRunning = true;
    private static Log log = LogFactory.getLog(CommandExecutorThread.class);

    public CommandExecutorThread(JbpmConfiguration jbpmConfiguration) {
        super("JbpmCommandExecutor");
        this.jbpmConfiguration = jbpmConfiguration;
        if (this.jbpmConfiguration == null) {
            throw new JbpmException("jbpmConfiguration is null");
        }
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setErrorDestination(String errorDestination) {
        this.errorDestination = errorDestination;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public void setJbpmContextName(String jbpmContextName) {
        this.jbpmContextName = jbpmContextName;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void quit() {
        this.keepRunning = false;
        this.interrupt();
    }

    public boolean executeCommand() throws Exception {
        boolean checkForMoreMessages = false;
        Message message = null;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext(this.jbpmContextName);
        try {
            try {
                DbMessageService dbMessageService = null;
                try {
                    dbMessageService = (DbMessageService)jbpmContext.getServices().getMessageService();
                }
                catch (ClassCastException e) {
                    throw new ConfigurationException("CommandExecutorThread only works with the DbMessageService implementation of the MessageService. please, configure jbpm.cfg.xml accordingly.");
                }
                if (dbMessageService == null) {
                    throw new ConfigurationException("no messaging service available");
                }
                message = dbMessageService.receiveNoWait(this.destination);
                if (message != null) {
                    checkForMoreMessages = true;
                    Command command = (Command)((Object)message);
                    log.trace((Object)("executing command '" + command + "'"));
                    command.execute();
                }
            }
            catch (Exception e) {
                log.debug((Object)("command '" + message + "' threw exception. rolling back transaction"), (Throwable)e);
                jbpmContext.setRollbackOnly();
                if (message != null) {
                    throw new MessageProcessingException(message, (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            jbpmContext.close();
        }
        return checkForMoreMessages;
    }

    void handleProcessingException(MessageProcessingException e) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext(this.jbpmContextName);
        try {
            DbMessageService dbMessageSessionImpl = (DbMessageService)jbpmContext.getServices().getMessageService();
            MessagingSession messageSession = dbMessageSessionImpl.getMessagingSession();
            Message message = e.message;
            dbMessageSessionImpl.receiveByIdNoWait(message.getId());
            message = Message.createCopy(message);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            message.setException(sw.toString());
            message.setDestination(this.errorDestination);
            messageSession.save(message);
        }
        finally {
            jbpmContext.close();
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    static class MessageProcessingException
    extends Exception {
        private static final long serialVersionUID = 1L;
        Message message;

        public MessageProcessingException(Message message, Throwable cause) {
            super("message " + message + "' couldn't be processed", cause);
            this.message = message;
        }
    }
}

