/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.par;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ConfigurableParser;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.IoUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessArchive
implements ProblemListener {
    private static final long serialVersionUID = 1L;
    static List processArchiveParsers = ProcessArchive.getProcessArchiveParsers();
    String name = "";
    Map entries = new HashMap();
    List problems = new ArrayList();

    public ProcessArchive(ZipInputStream zipInputStream) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String entryName = zipEntry.getName();
            byte[] bytes = IoUtil.readBytes(zipInputStream);
            if (bytes != null) {
                this.entries.put(entryName, bytes);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    public ProcessDefinition parseProcessDefinition() {
        ProcessDefinition processDefinition = ProcessDefinition.createNewProcessDefinition();
        for (ProcessArchiveParser processArchiveParser : processArchiveParsers) {
            processDefinition = processArchiveParser.readFromArchive(this, processDefinition);
        }
        if (Problem.containsProblemsOfLevel(this.problems, 2)) {
            throw new JpdlException(this.problems);
        }
        return processDefinition;
    }

    public String toString() {
        return "process-archive(" + this.name + ")";
    }

    public Map getEntries() {
        return this.entries;
    }

    public byte[] getEntry(String entryName) {
        return (byte[])this.entries.get(entryName);
    }

    public InputStream getEntryInputStream(String entryName) {
        return new ByteArrayInputStream(this.getEntry(entryName));
    }

    public byte[] removeEntry(String entryName) {
        return (byte[])this.entries.remove(entryName);
    }

    public InputStream removeEntryInputStream(String entryName) {
        return new ByteArrayInputStream(this.removeEntry(entryName));
    }

    @Override
    public void addProblem(Problem problem) {
        this.problems.add(problem);
    }

    public List getProblems() {
        return this.problems;
    }

    public void resetProblems() {
        this.problems = new ArrayList();
    }

    static List getProcessArchiveParsers() {
        ArrayList<ProcessArchiveParser> processArchiveParsers = new ArrayList<ProcessArchiveParser>();
        try {
            String resource = JbpmConfiguration.Configs.getString("resource.parsers");
            InputStream parsersStream = ClassLoaderUtil.getStream(resource);
            Document document = XmlUtil.parseXmlInputStream(parsersStream);
            Iterator iter = XmlUtil.elementIterator(document.getDocumentElement(), "parser");
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String className = element.getAttribute("class");
                ProcessArchiveParser processArchiveParser = (ProcessArchiveParser)ClassLoaderUtil.loadClass(className).newInstance();
                if (processArchiveParser instanceof ConfigurableParser) {
                    ((ConfigurableParser)processArchiveParser).configure(element);
                }
                processArchiveParsers.add(processArchiveParser);
            }
        }
        catch (Exception e) {
            throw new JbpmException("couldn't parse process archive parsers (jbpm.parsers.xml)", e);
        }
        return processArchiveParsers;
    }
}

