/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.ExpressionEvaluatorImpl;

public class JbpmExpressionEvaluator {
    static ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
    static VariableResolver variableResolver = null;

    public static void setVariableResolver(VariableResolver variableResolver) {
        JbpmExpressionEvaluator.variableResolver = variableResolver;
    }

    public static Object evaluate(String expression, ExecutionContext executionContext) {
        Object result = null;
        ExecutionContext.pushCurrentContext(executionContext);
        try {
            try {
                VariableResolver usedResolver = null;
                usedResolver = variableResolver != null ? variableResolver : (VariableResolver)JbpmConfiguration.Configs.getObject("jbpm.variable.resolver");
                String dollarExpression = JbpmExpressionEvaluator.translateExpressionToDollars(expression);
                result = evaluator.evaluate(dollarExpression, Object.class, usedResolver, null);
            }
            catch (ELException e) {
                throw new JbpmException("couldn't evaluate expression '" + expression + "'", e.getRootCause() != null ? e.getRootCause() : e);
            }
        }
        finally {
            ExecutionContext.popCurrentContext(executionContext);
        }
        return result;
    }

    static String translateExpressionToDollars(String expression) {
        char[] chars = expression.toCharArray();
        int index = 0;
        while (index != -1) {
            if ((index = expression.indexOf("#{", index)) == -1) continue;
            chars[index] = 36;
            ++index;
        }
        return new String(chars);
    }
}

