/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.FunctionMapper;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.Coercions;
import org.jbpm.jpdl.el.impl.Expression;
import org.jbpm.jpdl.el.impl.Logger;

public class ConditionalExpression
extends Expression {
    Expression mCondition;
    Expression mTrueBranch;
    Expression mFalseBranch;

    public Expression getCondition() {
        return this.mCondition;
    }

    public void setCondition(Expression pCondition) {
        this.mCondition = pCondition;
    }

    public Expression getTrueBranch() {
        return this.mTrueBranch;
    }

    public void setTrueBranch(Expression pTrueBranch) {
        this.mTrueBranch = pTrueBranch;
    }

    public Expression getFalseBranch() {
        return this.mFalseBranch;
    }

    public void setFalseBranch(Expression pFalseBranch) {
        this.mFalseBranch = pFalseBranch;
    }

    public ConditionalExpression(Expression pCondition, Expression pTrueBranch, Expression pFalseBranch) {
        this.mCondition = pCondition;
        this.mTrueBranch = pTrueBranch;
        this.mFalseBranch = pFalseBranch;
    }

    @Override
    public String getExpressionString() {
        return "( " + this.mCondition.getExpressionString() + " ? " + this.mTrueBranch.getExpressionString() + " : " + this.mFalseBranch.getExpressionString() + " )";
    }

    @Override
    public Object evaluate(VariableResolver vr, FunctionMapper f, Logger l) throws ELException {
        boolean condition = Coercions.coerceToBoolean(this.mCondition.evaluate(vr, f, l), l);
        if (condition) {
            return this.mTrueBranch.evaluate(vr, f, l);
        }
        return this.mFalseBranch.evaluate(vr, f, l);
    }
}

