/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.BeanInstantiator;
import org.jbpm.instantiation.ConfigurationPropertyInstantiator;
import org.jbpm.instantiation.ConstructorInstantiator;
import org.jbpm.instantiation.FieldInstantiator;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.EqualsUtil;

public class Delegation
implements Parsable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Map instantiatorCache = new HashMap();
    long id = 0L;
    protected String className = null;
    protected String configuration = null;
    protected String configType = null;
    protected ProcessDefinition processDefinition = null;
    transient Object instance = null;
    private static final Log log;

    static {
        instantiatorCache.put(null, new FieldInstantiator());
        instantiatorCache.put("field", new FieldInstantiator());
        instantiatorCache.put("bean", new BeanInstantiator());
        instantiatorCache.put("constructor", new ConstructorInstantiator());
        instantiatorCache.put("configuration-property", new ConfigurationPropertyInstantiator());
        log = LogFactory.getLog(Delegation.class);
    }

    public Delegation() {
    }

    public Delegation(Object instance) {
        this.instance = instance;
    }

    public Delegation(String className) {
        this.className = className;
    }

    @Override
    public void read(Element delegateElement, JpdlXmlReader jpdlReader) {
        this.processDefinition = jpdlReader.getProcessDefinition();
        this.className = delegateElement.attributeValue("class");
        if (this.className == null) {
            jpdlReader.addWarning("no class specified in " + delegateElement.asXML());
        }
        this.configType = delegateElement.attributeValue("config-type");
        if (delegateElement.hasContent()) {
            try {
                StringWriter stringWriter = new StringWriter();
                XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createCompactFormat());
                for (Object node : delegateElement.content()) {
                    xmlWriter.write(node);
                }
                xmlWriter.flush();
                this.configuration = stringWriter.toString();
            }
            catch (IOException e) {
                jpdlReader.addWarning("io problem while parsing the configuration of " + delegateElement.asXML());
            }
        }
    }

    @Override
    public void write(Element element) {
        element.addAttribute("class", this.className);
        element.addAttribute("config-type", this.configType);
        String configuration = this.configuration;
        if (configuration != null) {
            try {
                Element actionElement = DocumentHelper.parseText((String)("<action>" + configuration + "</action>")).getRootElement();
                for (Node node : new ArrayList(actionElement.content())) {
                    node.setParent(null);
                    element.add(node);
                }
            }
            catch (DocumentException e) {
                log.error((Object)("couldn't create dom-tree for action configuration '" + configuration + "'"), (Throwable)e);
            }
        }
    }

    public Object getInstance() {
        if (this.instance == null) {
            this.instance = this.instantiate();
        }
        return this.instance;
    }

    public Object instantiate() {
        Object newInstance = null;
        ClassLoader classLoader = ClassLoaderUtil.getProcessClassLoader(this.processDefinition);
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("couldn't load delegation class '" + this.className + "'"), (Throwable)e);
        }
        Instantiator instantiator = null;
        try {
            instantiator = (Instantiator)instantiatorCache.get(this.configType);
            if (instantiator == null) {
                Class<?> instantiatorClass = classLoader.loadClass(this.configType);
                instantiator = (Instantiator)instantiatorClass.newInstance();
                instantiatorCache.put(this.configType, instantiator);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new JbpmException("couldn't instantiate custom instantiator '" + this.configType + "'", e);
        }
        try {
            newInstance = instantiator.instantiate(clazz, this.configuration);
        }
        catch (RuntimeException e) {
            log.error((Object)("couldn't instantiate delegation class '" + this.className + "'"), (Throwable)e);
        }
        return newInstance;
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String instantiatorType) {
        this.configType = instantiatorType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }
}

