/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.instantiation.FieldInstantiator;
import org.jbpm.instantiation.Instantiator;

public class BeanInstantiator
extends FieldInstantiator
implements Instantiator {
    private static final Log log = LogFactory.getLog(BeanInstantiator.class);

    @Override
    protected void setPropertyValue(Class clazz, Object newInstance, String propertyName, Element propertyElement) {
        try {
            String setterMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Method method = this.findSetter(clazz, setterMethodName);
            Class<?> propertyType = method.getParameterTypes()[0];
            method.setAccessible(true);
            method.invoke(newInstance, BeanInstantiator.getValue(propertyType, propertyElement));
        }
        catch (Exception e) {
            log.error((Object)("couldn't parse property '" + propertyName + "' to value '" + propertyElement.asXML() + "'"), (Throwable)e);
        }
    }

    private Method findSetter(Class clazz, String setterMethodName) {
        Method method = null;
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length && method == null) {
            if (setterMethodName.equals(methods[i].getName()) && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                method = methods[i];
            }
            ++i;
        }
        if (method == null && clazz != Object.class) {
            method = this.findSetter(clazz.getSuperclass(), setterMethodName);
        }
        return method;
    }
}

