/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.exe.MilestoneInstance;

public class MilestoneNode
extends Node {
    private static final long serialVersionUID = 1L;
    String tokenPath = ".";

    public MilestoneNode() {
    }

    public MilestoneNode(String name) {
        super(name);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        Token milestoneToken = token.findToken(this.tokenPath);
        if (this.isMilestoneReached(this.name, milestoneToken)) {
            token.getNode().leave(executionContext);
        } else {
            this.addMilestoneListener(this.name, milestoneToken);
        }
    }

    public boolean isMilestoneReached(String milestoneName, Token token) {
        MilestoneInstance mi = MilestoneInstance.getMilestoneInstance(milestoneName, token);
        return mi != null ? mi.isReached() : false;
    }

    public void addMilestoneListener(String milestoneName, Token token) {
        MilestoneInstance mi = MilestoneInstance.getMilestoneInstance(milestoneName, token);
        mi.addListener(token);
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public void setTokenPath(String relativeTokenPath) {
        this.tokenPath = relativeTokenPath;
    }
}

