/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.compatibility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.util.ReflectHelper;

public class JbpmSchemaUpdate {
    private static final Log log = LogFactory.getLog(JbpmSchemaUpdate.class);
    private ConnectionProvider connectionProvider;
    private Configuration configuration;
    private Dialect dialect;
    private List exceptions;

    public JbpmSchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public JbpmSchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect((Properties)connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)props);
        this.exceptions = new ArrayList();
    }

    public JbpmSchemaUpdate(Configuration cfg, Settings settings) throws HibernateException {
        this.configuration = cfg;
        this.dialect = settings.getDialect();
        this.connectionProvider = settings.getConnectionProvider();
        this.exceptions = new ArrayList();
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            File out = null;
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                    } else if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                    } else if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                    } else if (args[i].startsWith("--text")) {
                        doUpdate = false;
                    } else if (args[i].startsWith("--naming=")) {
                        cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName((String)args[i].substring(9)).newInstance());
                    } else if (args[i].startsWith("--output=")) {
                        out = new File(args[i].substring(9));
                    }
                } else {
                    cfg.addFile(args[i]);
                }
                ++i;
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            new JbpmSchemaUpdate(cfg).execute(script, doUpdate, out);
        }
        catch (Exception e) {
            log.error((Object)"Error running schema update", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void execute(boolean script, boolean doUpdate, File out) {
        log.info((Object)"Running hbm2ddl schema update");
        Connection connection = null;
        Statement stmt = null;
        boolean autoCommitWasEnabled = true;
        FileWriter writer = null;
        if (script && out != null) {
            try {
                log.info((Object)("Creating filewriter to file : " + out.getAbsolutePath()));
                writer = new FileWriter(out);
            }
            catch (IOException e) {
                log.debug((Object)"IOException while creating filewriter");
                log.debug((Object)e);
            }
        }
        this.exceptions.clear();
        try {
            try {
                DatabaseMetadata meta;
                try {
                    log.info((Object)"fetching database metadata");
                    connection = this.connectionProvider.getConnection();
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                        connection.setAutoCommit(true);
                        autoCommitWasEnabled = false;
                    }
                    meta = new DatabaseMetadata(connection, this.dialect);
                    stmt = connection.createStatement();
                }
                catch (SQLException sqle) {
                    this.exceptions.add(sqle);
                    log.error((Object)"could not get database metadata", (Throwable)sqle);
                    throw sqle;
                }
                log.info((Object)"updating schema");
                String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
                int j = 0;
                while (j < createSQL.length) {
                    String sql = createSQL[j];
                    try {
                        if (script) {
                            System.out.println(sql);
                            if (writer != null) {
                                writer.write(String.valueOf(sql) + ";\n");
                            }
                        }
                        if (doUpdate) {
                            log.debug((Object)sql);
                            stmt.executeUpdate(sql);
                        }
                    }
                    catch (SQLException e) {
                        this.exceptions.add(e);
                        log.error((Object)("Unsuccessful: " + sql));
                        log.error((Object)e.getMessage());
                    }
                    ++j;
                }
                if (writer != null) {
                    writer.close();
                }
                log.info((Object)"schema update complete");
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error((Object)"could not complete schema update", (Throwable)e);
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (!autoCommitWasEnabled) {
                        connection.setAutoCommit(false);
                    }
                    if (connection != null) {
                        connection.close();
                    }
                    if (this.connectionProvider != null) {
                        this.connectionProvider.close();
                    }
                }
                catch (Exception e2) {
                    this.exceptions.add(e2);
                    log.error((Object)"Error closing connection", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (!autoCommitWasEnabled) {
                    connection.setAutoCommit(false);
                }
                if (connection != null) {
                    connection.close();
                }
                if (this.connectionProvider != null) {
                    this.connectionProvider.close();
                }
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error((Object)"Error closing connection", (Throwable)e);
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }
}

