/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.scheduler.exe.Timer;

public class SchedulerSession {
    JbpmSession jbpmSession = null;
    Session session = null;
    Set deletedTimers = new HashSet();
    List openIterators = null;
    private static final Log log = LogFactory.getLog(SchedulerSession.class);

    public SchedulerSession(JbpmSession jbpmSession) {
        this.jbpmSession = jbpmSession;
        this.session = jbpmSession.getSession();
    }

    public SchedulerSession(Session session) {
        this.session = session;
        this.jbpmSession = new JbpmSession(session);
    }

    public void saveTimer(Timer timer) {
        try {
            log.debug((Object)"saving timer");
            this.session.save((Object)timer);
            Action action = timer.getAction();
            if (action != null && !this.session.contains((Object)action)) {
                log.debug((Object)"cascading timer save to timer action");
                this.session.save((Object)action);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't save timer '" + timer + "' to the database", e);
        }
    }

    public void deleteTimer(Timer timer) {
        if (!this.deletedTimers.contains(timer)) {
            try {
                this.session.delete((Object)timer);
                this.deletedTimers.add(timer);
            }
            catch (Exception e) {
                log.error((Object)e);
                this.jbpmSession.handleException();
                throw new JbpmException("couldn't delete timer '" + timer + "' from the database", e);
            }
        }
    }

    public Iterator findTimersByDueDate(int maxResultCount) {
        try {
            Query query = this.session.getNamedQuery("SchedulerSession.findTimersByDueDate");
            query.setMaxResults(maxResultCount);
            Iterator iterator = query.iterate();
            this.addOpenIterator(iterator);
            return iterator;
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find timers from the database", e);
        }
    }

    public Iterator findFailedTimers() {
        try {
            Iterator iterator = this.session.getNamedQuery("SchedulerSession.findFailedTimers").iterate();
            this.addOpenIterator(iterator);
            return iterator;
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find failed timers from the database", e);
        }
    }

    public Iterator findSuspendedTimers() {
        try {
            Iterator iterator = this.session.getNamedQuery("SchedulerSession.findSuspendedTimers").iterate();
            this.addOpenIterator(iterator);
            return iterator;
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find failed timers from the database", e);
        }
    }

    private void addOpenIterator(Iterator iterator) {
        if (this.openIterators == null) {
            this.openIterators = new ArrayList();
        }
        this.openIterators.add(iterator);
    }

    public void closeOpenIterators() {
        if (this.openIterators != null) {
            for (Iterator messageIterator : this.openIterators) {
                Hibernate.close((Iterator)messageIterator);
            }
        }
    }

    public void cancelTimersByName(String timerName, Token token) {
        try {
            Query query = this.session.getNamedQuery("SchedulerSession.findTimersByName");
            query.setString("timerName", timerName);
            query.setEntity("token", (Object)token);
            Iterator iter = query.list().iterator();
            while (iter.hasNext()) {
                this.deleteTimer((Timer)iter.next());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete timer '" + timerName + "' on '" + token + "' from the database", e);
        }
    }

    public List findTimersByName(String timerName, Token token) {
        List results = null;
        try {
            Query query = this.session.getNamedQuery("SchedulerSession.findTimersByName");
            query.setString("timerName", timerName);
            query.setEntity("token", (Object)token);
            results = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find timers '" + timerName + "' in '" + token + "' from the database", e);
        }
        return results;
    }

    public void cancelTimersForProcessInstance(ProcessInstance processInstance) {
        try {
            Query query = this.session.getNamedQuery("SchedulerSession.deleteTimersForProcessInstance");
            query.setEntity("processInstance", (Object)processInstance);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete timers for process instance '" + processInstance + "'", e);
        }
    }

    public void suspendTimersForProcessInstance(Token token) {
        try {
            Query query = this.session.getNamedQuery("SchedulerSession.suspendTimersForToken");
            query.setEntity("token", (Object)token);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete timers for token '" + token + "'", e);
        }
    }

    public void resumeTimersForProcessInstance(Token token) {
        try {
            Query query = this.session.getNamedQuery("SchedulerSession.resumeTimersForToken");
            query.setEntity("token", (Object)token);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete timers for token '" + token + "'", e);
        }
    }
}

