/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSchema;
import org.jbpm.db.JbpmSession;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmSessionFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    static String jndiName = JbpmSessionFactory.getJndiName();
    Configuration configuration = null;
    SessionFactory sessionFactory = null;
    Collection hibernatableLongIdClasses = null;
    Collection hibernatableStringIdClasses = null;
    JbpmSchema jbpmSchema = null;
    static JbpmSessionFactory instance = null;
    private static final Log log = LogFactory.getLog(JbpmSessionFactory.class);

    private static String getJndiName() {
        String jndiName = null;
        if (JbpmConfiguration.Configs.hasObject("jbpm.session.factory.jndi.name")) {
            jndiName = JbpmConfiguration.Configs.getString("jbpm.session.factory.jndi.name");
        }
        return jndiName;
    }

    public static JbpmSessionFactory getInstance() {
        if (instance == null) {
            if (jndiName != null) {
                try {
                    log.debug((Object)("fetching JbpmSessionFactory from '" + jndiName + "'"));
                    InitialContext initialContext = new InitialContext();
                    Object o = initialContext.lookup(jndiName);
                    instance = (JbpmSessionFactory)PortableRemoteObject.narrow((Object)o, JbpmSessionFactory.class);
                }
                catch (Exception e) {
                    throw new JbpmException("couldn't fetch JbpmSessionFactory from jndi '" + jndiName + "'");
                }
            } else {
                log.debug((Object)"building singleton JbpmSessionFactory");
                instance = JbpmSessionFactory.buildJbpmSessionFactory();
            }
        }
        return instance;
    }

    public JbpmSessionFactory(Configuration configuration) {
        this(configuration, JbpmSessionFactory.buildSessionFactory(configuration));
    }

    public JbpmSessionFactory(Configuration configuration, SessionFactory sessionFactory) {
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
    }

    public static JbpmSessionFactory buildJbpmSessionFactory() {
        return JbpmSessionFactory.buildJbpmSessionFactory(JbpmSessionFactory.getConfigResource());
    }

    public static JbpmSessionFactory buildJbpmSessionFactory(String configResource) {
        return JbpmSessionFactory.buildJbpmSessionFactory(JbpmSessionFactory.createConfiguration(configResource));
    }

    public static JbpmSessionFactory buildJbpmSessionFactory(Configuration configuration) {
        return new JbpmSessionFactory(configuration);
    }

    private static String getConfigResource() {
        return JbpmConfiguration.Configs.getString("resource.hibernate.cfg.xml");
    }

    public static Configuration createConfiguration() {
        return JbpmSessionFactory.createConfiguration(JbpmSessionFactory.getConfigResource());
    }

    public static Configuration createConfiguration(String configResource) {
        Configuration configuration = null;
        configuration = new Configuration();
        if (configResource != null) {
            log.debug((Object)("using '" + configResource + "' as hibernate configuration for jbpm"));
            configuration.configure(configResource);
        } else {
            log.debug((Object)"using the default hibernate configuration file: hibernate.cfg.xml");
            configuration.configure();
        }
        if (JbpmConfiguration.Configs.hasObject("resource.hibernate.properties")) {
            String hibernatePropertiesResource = JbpmConfiguration.Configs.getString("resource.hibernate.properties");
            Properties hibernateProperties = new Properties();
            try {
                hibernateProperties.load(ClassLoaderUtil.getStream(hibernatePropertiesResource));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new JbpmException("couldn't load the hibernate properties from resource '" + hibernatePropertiesResource + "'", e);
            }
            log.debug((Object)("overriding hibernate properties with " + hibernateProperties));
            configuration.setProperties(hibernateProperties);
        }
        return configuration;
    }

    public static SessionFactory buildSessionFactory(Configuration configuration) {
        SessionFactory sessionFactory = null;
        log.debug((Object)"building hibernate session factory");
        sessionFactory = configuration.buildSessionFactory();
        return sessionFactory;
    }

    public JbpmSession openJbpmSession() {
        return this.openJbpmSession((Connection)null);
    }

    public JbpmSession openJbpmSession(Connection jdbcConnection) {
        JbpmSession dbSession = null;
        try {
            Session session = null;
            session = jdbcConnection == null ? this.getSessionFactory().openSession() : this.getSessionFactory().openSession(jdbcConnection);
            dbSession = new JbpmSession(this, (org.hibernate.Session)session);
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("couldn't create a hibernate persistence session", e);
        }
        return dbSession;
    }

    public JbpmSession openJbpmSession(org.hibernate.Session session) {
        return new JbpmSession(null, session);
    }

    public JbpmSession openJbpmSessionAndBeginTransaction() {
        JbpmSession dbSession = this.openJbpmSession((Connection)null);
        dbSession.beginTransaction();
        return dbSession;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isHibernatableWithLongId(Class clazz) {
        if (this.hibernatableLongIdClasses == null) {
            this.initHibernatableClasses();
        }
        return this.hibernatableLongIdClasses.contains(clazz);
    }

    public boolean isHibernatableWithStringId(Class clazz) {
        if (this.hibernatableStringIdClasses == null) {
            this.initHibernatableClasses();
        }
        return this.hibernatableStringIdClasses.contains(clazz);
    }

    public JbpmSchema getJbpmSchema() {
        if (this.jbpmSchema == null) {
            this.jbpmSchema = new JbpmSchema(this.configuration);
        }
        return this.jbpmSchema;
    }

    void initHibernatableClasses() {
        this.hibernatableLongIdClasses = new HashSet();
        this.hibernatableStringIdClasses = new HashSet();
        Iterator iter = this.configuration.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)iter.next();
            if (LongType.class == persistentClass.getIdentifier().getType().getClass()) {
                this.hibernatableLongIdClasses.add(persistentClass.getMappedClass());
                continue;
            }
            if (StringType.class != persistentClass.getIdentifier().getType().getClass()) continue;
            this.hibernatableStringIdClasses.add(persistentClass.getMappedClass());
        }
    }
}

