/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jbpm.JbpmException;
import org.jbpm.bytes.ByteArray;
import org.jbpm.context.exe.Converter;

public class SerializableToByteArrayConverter
implements Converter {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean supports(Object value) {
        if (value == null) {
            return true;
        }
        return Serializable.class.isAssignableFrom(value.getClass());
    }

    @Override
    public Object convert(Object o) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new JbpmException("couldn't serialize '" + o + "'", e);
        }
        return new ByteArray(bytes);
    }

    @Override
    public Object revert(Object o) {
        ByteArray byteArray = (ByteArray)o;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray.getBytes());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't deserialize object", e);
        }
    }
}

