/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class PropertyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    String propertyName = null;
    String setterMethodName = null;
    ObjectInfo propertyValueInfo = null;

    public PropertyInfo(Element propertyElement, ObjectFactoryParser configParser) {
        if (propertyElement.hasAttribute("name")) {
            this.propertyName = propertyElement.getAttribute("name");
        } else if (propertyElement.hasAttribute("setter")) {
            this.setterMethodName = propertyElement.getAttribute("setter");
        } else {
            throw new JbpmException("property must have a 'name' or 'setter' attribute: " + XmlUtil.toString(propertyElement));
        }
        Element propertyValueElement = XmlUtil.element(propertyElement);
        this.propertyValueInfo = configParser.parse(propertyValueElement);
    }

    public void injectProperty(Object object, ObjectFactoryImpl objectFactory) {
        Object propertyValue = objectFactory.getObject(this.propertyValueInfo);
        Method setterMethod = this.findSetter(object.getClass());
        setterMethod.setAccessible(true);
        try {
            setterMethod.invoke(object, propertyValue);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't set property '" + this.propertyName + "' on class '" + object.getClass() + "' to value '" + propertyValue + "'", e);
        }
    }

    public Method findSetter(Class clazz) {
        Method method = null;
        if (this.setterMethodName == null) {
            this.setterMethodName = this.propertyName.startsWith("is") && this.propertyName.length() > 3 && Character.isUpperCase(this.propertyName.charAt(2)) ? "set" + this.propertyName.substring(2) : "set" + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        }
        Class candidateClass = clazz;
        while (candidateClass != null && method == null) {
            Method[] methods = candidateClass.getDeclaredMethods();
            if (methods != null) {
                int i = 0;
                while (i < methods.length && method == null) {
                    if (methods[i].getName().equals(this.setterMethodName) && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                        method = methods[i];
                    }
                    ++i;
                }
            }
            if (method != null) continue;
            candidateClass = candidateClass.getSuperclass();
        }
        if (method == null) {
            throw new JbpmException("couldn't find setter '" + this.setterMethodName + "' in class '" + clazz.getName() + "'");
        }
        return method;
    }
}

