/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.ClassLoaderUtil;

public class ObjectFactoryImpl
implements ObjectFactory {
    private static final long serialVersionUID = 1L;
    ClassLoader classLoader = ClassLoaderUtil.getClassLoader();
    List objectInfos = null;
    Map namedObjectInfos = null;
    Map singletons = new HashMap();
    Map objects = new HashMap();
    Collection objectsUnderConstruction = new HashSet();
    private static Log log = LogFactory.getLog(ObjectFactoryImpl.class);

    public ObjectFactoryImpl() {
        this.objectInfos = new ArrayList();
        this.namedObjectInfos = new HashMap();
    }

    public ObjectFactoryImpl(Map namedObjectInfos, List objectInfos) {
        this.namedObjectInfos = namedObjectInfos;
        this.objectInfos = objectInfos;
    }

    public void addObjectInfo(ObjectInfo objectInfo) {
        if (objectInfo.hasName()) {
            log.debug((Object)("adding object info '" + objectInfo.getName() + "'"));
            ObjectInfo removed = this.namedObjectInfos.put(objectInfo.getName(), objectInfo);
            if (removed != null) {
                this.objectInfos.remove(removed);
            }
        }
        this.objectInfos.add(objectInfo);
    }

    @Override
    public synchronized Object createObject(String name) {
        ObjectInfo objectInfo = (ObjectInfo)this.namedObjectInfos.get(name);
        if (objectInfo == null) {
            throw new ConfigurationException("name '" + name + "' is not defined in the configuration. configured names: " + this.namedObjectInfos.keySet());
        }
        return this.createObject(objectInfo);
    }

    @Override
    public synchronized boolean hasObject(String name) {
        return this.namedObjectInfos.containsKey(name);
    }

    public Object createObject(int index) {
        if (index < 0 || index >= this.objectInfos.size()) {
            throw new ConfigurationException("index '" + index + "' is not defined in the configuration.  range [0.." + (this.objectInfos.size() - 1) + "]");
        }
        return this.createObject((ObjectInfo)this.objectInfos.get(index));
    }

    public Object createObject(ObjectInfo objectInfo) {
        this.clearRegistry();
        return this.getObject(objectInfo);
    }

    void clearRegistry() {
        this.objects.clear();
        this.objectsUnderConstruction.clear();
    }

    Object getObject(String name) {
        Object object = null;
        ObjectInfo objectInfo = (ObjectInfo)this.namedObjectInfos.get(name);
        if (objectInfo != null) {
            object = this.getObject(objectInfo);
        } else {
            log.warn((Object)("no info for object '" + name + "'. defined objects: " + this.namedObjectInfos.keySet().toString()));
        }
        return object;
    }

    Object getObject(ObjectInfo objectInfo) {
        Object object = null;
        Object registryKey = this.getRegistryKey(objectInfo);
        if (this.isInRegistry(registryKey)) {
            object = this.findInRegistry(registryKey);
        } else if (registryKey != null) {
            if (this.objectsUnderConstruction.contains(registryKey)) {
                throw new JbpmException("circular object dependency on bean '" + registryKey + "'");
            }
            this.objectsUnderConstruction.add(registryKey);
            try {
                object = objectInfo.createObject(this);
            }
            finally {
                this.objectsUnderConstruction.remove(registryKey);
            }
            this.putInRegistry(objectInfo, object, registryKey);
        } else {
            object = objectInfo.createObject(this);
        }
        return object;
    }

    Class loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("couldn't load class '" + className + "'", e);
        }
    }

    Object getRegistryKey(ObjectInfo objectInfo) {
        String key = null;
        if (objectInfo.hasName()) {
            key = objectInfo.getName();
        }
        return key;
    }

    boolean isInRegistry(Object registryKey) {
        return registryKey != null && (this.objects.containsKey(registryKey) || this.singletons.containsKey(registryKey));
    }

    void putInRegistry(ObjectInfo objectInfo, Object object, Object registryKey) {
        if (objectInfo.isSingleton()) {
            this.singletons.put(registryKey, object);
        } else {
            this.objects.put(registryKey, object);
        }
    }

    Object findInRegistry(Object registryKey) {
        Object object = null;
        if (registryKey != null && (object = this.objects.get(registryKey)) == null) {
            object = this.singletons.get(registryKey);
        }
        return object;
    }
}

