/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.lang.reflect.Field;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.PropertyInfo;
import org.w3c.dom.Element;

public class FieldInfo
extends PropertyInfo {
    private static final long serialVersionUID = 1L;

    public FieldInfo(Element fieldElement, ObjectFactoryParser configParser) {
        super(fieldElement, configParser);
    }

    @Override
    public void injectProperty(Object object, ObjectFactoryImpl objectFactory) {
        Object propertyValue = objectFactory.getObject(this.propertyValueInfo);
        Field propertyField = this.findField(object.getClass());
        propertyField.setAccessible(true);
        try {
            propertyField.set(object, propertyValue);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't set field '" + this.propertyName + "' on class '" + object.getClass() + "' to value '" + propertyValue + "'", e);
        }
    }

    Field findField(Class clazz) {
        Field field = null;
        Class candidateClass = clazz;
        while (candidateClass != null && field == null) {
            try {
                field = candidateClass.getDeclaredField(this.propertyName);
            }
            catch (Exception e) {
                candidateClass = candidateClass.getSuperclass();
            }
        }
        if (field == null) {
            throw new JbpmException("couldn't find field '" + this.propertyName + "' in class '" + clazz.getName() + "'");
        }
        return field;
    }
}

