/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

public abstract class AntHelper {
    static final Map configurations = new HashMap();
    static final Map jbpmConfigurations = new HashMap();
    private static final Log log = LogFactory.getLog(AntHelper.class);

    public static Configuration getConfiguration(String cfgFileName, String propertiesFileName) {
        Object key = AntHelper.getKey(cfgFileName, propertiesFileName);
        Configuration configuration = (Configuration)configurations.get(key);
        if (configuration == null) {
            log.debug((Object)("creating hibernate configuration from cfg '" + cfgFileName + "' and properties '" + propertiesFileName + "'"));
            File cfgFile = new File(cfgFileName);
            configuration = new Configuration();
            configuration.configure(cfgFile);
            if (propertiesFileName != null) {
                try {
                    File propertiesFile = new File(propertiesFileName);
                    FileInputStream propertiesInputStream = new FileInputStream(propertiesFile);
                    Properties properties = new Properties();
                    properties.load(propertiesInputStream);
                    configuration.setProperties(properties);
                }
                catch (Exception e) {
                    throw new JbpmException("couldn't set properties '" + propertiesFileName + "'", e);
                }
            }
            configurations.put(key, configuration);
        } else {
            log.debug((Object)("got hibernate configuration from cfg '" + cfgFileName + "' and properties '" + propertiesFileName + "' from the cache"));
        }
        return configuration;
    }

    public static JbpmConfiguration getJbpmConfiguration(String cfg, String properties) {
        Object key = AntHelper.getKey(cfg, properties);
        JbpmConfiguration jbpmConfiguration = (JbpmConfiguration)jbpmConfigurations.get(key);
        if (jbpmConfiguration == null) {
            jbpmConfiguration = JbpmConfiguration.parseXmlString("<jbpm-configuration> <jbpm-context>  <service name='persistence' factory='org.jbpm.persistence.db.DbPersistenceServiceFactory' /> </jbpm-context> <string name='resource.business.calendar' value='org/jbpm/calendar/jbpm.business.calendar.properties' /> <string name='resource.default.modules' value='org/jbpm/graph/def/jbpm.default.modules.properties' /> <string name='resource.converter' value='org/jbpm/db/hibernate/jbpm.converter.properties' /> <string name='resource.action.types' value='org/jbpm/graph/action/action.types.xml' /> <string name='resource.node.types' value='org/jbpm/graph/node/node.types.xml' /> <string name='resource.parsers' value='org/jbpm/jpdl/par/jbpm.parsers.xml' /> <string name='resource.varmapping' value='org/jbpm/context/exe/jbpm.varmapping.xml' /></jbpm-configuration>");
            Configuration configuration = AntHelper.getConfiguration(cfg, properties);
            DbPersistenceServiceFactory dbPersistenceServiceFactory = (DbPersistenceServiceFactory)jbpmConfiguration.getServiceFactory("persistence");
            dbPersistenceServiceFactory.setConfiguration(configuration);
            jbpmConfigurations.put(key, jbpmConfiguration);
        }
        return jbpmConfiguration;
    }

    static Object getKey(String cfg, String properties) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(cfg);
        key.add(properties);
        return key;
    }
}

