/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.builder;

import javax.sql.DataSource;
import org.springframework.batch.item.database.StoredProcedureItemReader;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StoredProcedureItemReaderBuilder<T> {
    public static final int VALUE_NOT_SET = -1;
    private int currentItemCount = 0;
    private int maxItemCount = Integer.MAX_VALUE;
    private boolean saveState = true;
    private DataSource dataSource;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean ignoreWarnings = true;
    private boolean verifyCursorPosition = true;
    private boolean driverSupportsAbsolute = false;
    private boolean useSharedExtendedConnection = false;
    private PreparedStatementSetter preparedStatementSetter;
    private RowMapper<T> rowMapper;
    private String procedureName;
    private SqlParameter[] parameters = new SqlParameter[0];
    private boolean function = false;
    private int refCursorPosition = 0;
    private String name;

    public StoredProcedureItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> maxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> queryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> ignoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> verifyCursorPosition(boolean verifyCursorPosition) {
        this.verifyCursorPosition = verifyCursorPosition;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> driverSupportsAbsolute(boolean driverSupportsAbsolute) {
        this.driverSupportsAbsolute = driverSupportsAbsolute;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> useSharedExtendedConnection(boolean useSharedExtendedConnection) {
        this.useSharedExtendedConnection = useSharedExtendedConnection;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> preparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> rowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> procedureName(String procedureName) {
        this.procedureName = procedureName;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> parameters(SqlParameter ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> function() {
        this.function = true;
        return this;
    }

    public StoredProcedureItemReaderBuilder<T> refCursorPosition(int refCursorPosition) {
        this.refCursorPosition = refCursorPosition;
        return this;
    }

    public StoredProcedureItemReader<T> build() {
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveSate is set to true");
        }
        Assert.notNull((Object)this.procedureName, (String)"The name of the stored procedure must be provided");
        Assert.notNull((Object)this.dataSource, (String)"A datasource is required");
        Assert.notNull(this.rowMapper, (String)"A rowmapper is required");
        StoredProcedureItemReader<T> itemReader = new StoredProcedureItemReader<T>();
        if (StringUtils.hasText((String)this.name)) {
            itemReader.setName(this.name);
        }
        itemReader.setProcedureName(this.procedureName);
        itemReader.setRowMapper(this.rowMapper);
        itemReader.setParameters(this.parameters);
        itemReader.setPreparedStatementSetter(this.preparedStatementSetter);
        itemReader.setFunction(this.function);
        itemReader.setRefCursorPosition(this.refCursorPosition);
        itemReader.setCurrentItemCount(this.currentItemCount);
        itemReader.setDataSource(this.dataSource);
        itemReader.setDriverSupportsAbsolute(this.driverSupportsAbsolute);
        itemReader.setFetchSize(this.fetchSize);
        itemReader.setIgnoreWarnings(this.ignoreWarnings);
        itemReader.setMaxItemCount(this.maxItemCount);
        itemReader.setMaxRows(this.maxRows);
        itemReader.setQueryTimeout(this.queryTimeout);
        itemReader.setSaveState(this.saveState);
        itemReader.setUseSharedExtendedConnection(this.useSharedExtendedConnection);
        itemReader.setVerifyCursorPosition(this.verifyCursorPosition);
        return itemReader;
    }
}

