/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.io.Utf8;
import java.nio.charset.StandardCharsets;

abstract class CVUtil {
    CVUtil() {
    }

    static int putByte(byte b, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 1;
        }
        int pos = initialPos;
        buffer[pos++] = b;
        return pos;
    }

    static int putShort(short s, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 2;
        }
        int pos = initialPos;
        buffer[pos++] = (byte)(s & 0xFF);
        buffer[pos++] = (byte)(s >> 8 & 0xFF);
        return pos;
    }

    static int putInt(int i, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 4;
        }
        int pos = initialPos;
        buffer[pos++] = (byte)(i & 0xFF);
        buffer[pos++] = (byte)(i >> 8 & 0xFF);
        buffer[pos++] = (byte)(i >> 16 & 0xFF);
        buffer[pos++] = (byte)(i >> 24 & 0xFF);
        return pos;
    }

    static int putLong(long l, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 8;
        }
        int pos = initialPos;
        buffer[pos++] = (byte)(l & 0xFFL);
        buffer[pos++] = (byte)(l >> 8 & 0xFFL);
        buffer[pos++] = (byte)(l >> 16 & 0xFFL);
        buffer[pos++] = (byte)(l >> 24 & 0xFFL);
        buffer[pos++] = (byte)(l >> 32 & 0xFFL);
        buffer[pos++] = (byte)(l >> 40 & 0xFFL);
        buffer[pos++] = (byte)(l >> 48 & 0xFFL);
        buffer[pos++] = (byte)(l >> 56 & 0xFFL);
        return pos;
    }

    static int putBytes(byte[] inbuff, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + inbuff.length;
        }
        int pos = initialPos;
        for (byte b : inbuff) {
            buffer[pos++] = b;
        }
        return pos;
    }

    static int putUTF8StringBytes(String s, byte[] buffer, int initialPos) {
        assert (!s.contains("\u0000"));
        if (buffer == null) {
            return initialPos + Utf8.utf8Length(s) + 1;
        }
        byte[] buff = s.getBytes(StandardCharsets.UTF_8);
        int pos = CVUtil.putBytes(buff, buffer, initialPos);
        buffer[pos++] = 0;
        return pos;
    }

    static int align4(int initialPos) {
        int pos = initialPos;
        while ((pos & 3) != 0) {
            ++pos;
        }
        return pos;
    }
}

