/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DCLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl.PostgreSQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLAlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLAlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLCreateGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLDropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLDropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLGrantStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLReassignOwnedStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dcl.PostgreSQLRevokeStatement;

public final class PostgreSQLDCLStatementSQLVisitor
extends PostgreSQLStatementSQLVisitor
implements DCLSQLVisitor,
SQLStatementVisitor {
    public PostgreSQLDCLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitGrant(PostgreSQLStatementParser.GrantContext ctx) {
        PostgreSQLGrantStatement result = new PostgreSQLGrantStatement();
        Optional<Collection> tableSegment = null == ctx.privilegeClause() ? Optional.empty() : this.getTableFromPrivilegeClause(ctx.privilegeClause());
        tableSegment.ifPresent(optional -> result.getTables().addAll(optional));
        return result;
    }

    @Override
    public ASTNode visitRevoke(PostgreSQLStatementParser.RevokeContext ctx) {
        PostgreSQLRevokeStatement result = new PostgreSQLRevokeStatement();
        Optional<Collection> tableSegment = null == ctx.privilegeClause() ? Optional.empty() : this.getTableFromPrivilegeClause(ctx.privilegeClause());
        tableSegment.ifPresent(optional -> result.getTables().addAll(optional));
        return result;
    }

    private Optional<Collection<SimpleTableSegment>> getTableFromPrivilegeClause(PostgreSQLStatementParser.PrivilegeClauseContext ctx) {
        if (null == ctx.onObjectClause() || null == ctx.onObjectClause().privilegeLevel()) {
            return Optional.empty();
        }
        if (null == ctx.onObjectClause().privilegeLevel().tableNames()) {
            return Optional.empty();
        }
        return Optional.of(((CollectionValue)this.visit((ParseTree)ctx.onObjectClause().privilegeLevel().tableNames())).getValue());
    }

    @Override
    public ASTNode visitCreateUser(PostgreSQLStatementParser.CreateUserContext ctx) {
        return new PostgreSQLCreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(PostgreSQLStatementParser.DropUserContext ctx) {
        return new PostgreSQLDropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(PostgreSQLStatementParser.AlterUserContext ctx) {
        return new PostgreSQLAlterUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(PostgreSQLStatementParser.CreateRoleContext ctx) {
        return new PostgreSQLCreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(PostgreSQLStatementParser.AlterRoleContext ctx) {
        return new PostgreSQLAlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(PostgreSQLStatementParser.DropRoleContext ctx) {
        return new PostgreSQLDropRoleStatement();
    }

    @Override
    public ASTNode visitReassignOwned(PostgreSQLStatementParser.ReassignOwnedContext ctx) {
        return new PostgreSQLReassignOwnedStatement();
    }

    @Override
    public ASTNode visitCreateGroup(PostgreSQLStatementParser.CreateGroupContext ctx) {
        return new PostgreSQLCreateGroupStatement();
    }

    @Generated
    public PostgreSQLDCLStatementSQLVisitor() {
    }
}

