/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.config.swapper;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;

public final class YamlDataSourceConfigurationSwapper {
    private static final String DATA_SOURCE_CLASS_NAME_KEY = "dataSourceClassName";

    public Map<String, DataSource> swapToDataSources(Map<String, Map<String, Object>> yamlDataSources) {
        return DataSourceConverter.getDataSourceMap(yamlDataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapToDataSourceConfiguration((Map)entry.getValue()))));
    }

    public DataSourceConfiguration swapToDataSourceConfiguration(Map<String, Object> yamlConfig) {
        Preconditions.checkState((boolean)yamlConfig.containsKey(DATA_SOURCE_CLASS_NAME_KEY), (String)"%s can not be null.", (Object)DATA_SOURCE_CLASS_NAME_KEY);
        HashMap<String, Object> newDataSourceMap = new HashMap<String, Object>(yamlConfig);
        newDataSourceMap.remove(DATA_SOURCE_CLASS_NAME_KEY);
        DataSourceConfiguration result = new DataSourceConfiguration(yamlConfig.get(DATA_SOURCE_CLASS_NAME_KEY).toString());
        if (null != newDataSourceMap.get("customPoolProps")) {
            result.getCustomPoolProps().putAll((Map<?, ?>)((Map)newDataSourceMap.get("customPoolProps")));
            newDataSourceMap.remove("customPoolProps");
        }
        result.getProps().putAll(newDataSourceMap);
        return result;
    }

    public Map<String, Object> swapToMap(DataSourceConfiguration dataSourceConfig) {
        HashMap<String, Object> result = new HashMap<String, Object>(dataSourceConfig.getProps());
        if (!dataSourceConfig.getCustomPoolProps().isEmpty()) {
            result.put("customPoolProps", dataSourceConfig.getCustomPoolProps());
        }
        result.put(DATA_SOURCE_CLASS_NAME_KEY, dataSourceConfig.getDataSourceClassName());
        return result;
    }
}

