/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.resource;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.DatabaseAccessConfiguration;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.MemorizedDataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;

public final class DataSourcesMetaData {
    private final Map<String, DataSourceMetaData> dataSourceMetaDataMap;

    public DataSourcesMetaData(DatabaseType databaseType, Map<String, DatabaseAccessConfiguration> databaseAccessConfigs) {
        this.dataSourceMetaDataMap = databaseAccessConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> databaseType.getDataSourceMetaData(((DatabaseAccessConfiguration)entry.getValue()).getUrl(), ((DatabaseAccessConfiguration)entry.getValue()).getUsername()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, DataSourceMetaData> entry : this.dataSourceMetaDataMap.entrySet()) {
            if (this.isExisted(entry.getKey(), result)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        return existedDataSourceNames.stream().anyMatch(each -> this.isInSameDatabaseInstance(this.dataSourceMetaDataMap.get(dataSourceName), this.dataSourceMetaDataMap.get(each)));
    }

    private boolean isInSameDatabaseInstance(DataSourceMetaData sample, DataSourceMetaData target) {
        return sample instanceof MemorizedDataSourceMetaData ? Objects.equals(target.getSchema(), sample.getSchema()) : target.getHostName().equals(sample.getHostName()) && target.getPort() == sample.getPort();
    }

    public DataSourceMetaData getDataSourceMetaData(String dataSourceName) {
        return this.dataSourceMetaDataMap.get(dataSourceName);
    }
}

