/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.mysql.type;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.dbdiscovery.spi.ReplicaDataSourceStatus;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.util.exception.sql.SQLWrapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLNormalReplicationDatabaseDiscoveryProviderAlgorithm
implements DatabaseDiscoveryProviderAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLNormalReplicationDatabaseDiscoveryProviderAlgorithm.class);
    private static final String SHOW_SLAVE_STATUS = "SHOW SLAVE STATUS";
    private static final String SHOW_SLAVE_HOSTS = "SHOW SLAVE HOSTS";
    private static final String SHOW_VARIABLES_READ_ONLY = "SHOW VARIABLES LIKE 'read_only'";
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public void checkEnvironment(String databaseName, Collection<DataSource> dataSources) {
        ExecutorService executorService = ExecutorEngine.createExecutorEngineWithCPUAndResources((int)dataSources.size()).getExecutorServiceManager().getExecutorService();
        LinkedList<CompletableFuture<Boolean>> completableFutures = new LinkedList<CompletableFuture<Boolean>>();
        for (DataSource dataSource : dataSources) {
            completableFutures.add(this.supplyAsyncCheckEnvironment(dataSource, executorService));
        }
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0]));
        Iterator primaryInstancesFuture = completableFutures.stream().iterator();
        int primaryCount = 0;
        while (primaryInstancesFuture.hasNext()) {
            if (!((Boolean)((CompletableFuture)primaryInstancesFuture.next()).join()).booleanValue()) continue;
            ++primaryCount;
        }
        Preconditions.checkState((1 == primaryCount ? 1 : 0) != 0, (String)"Check Environment are failed in database `%s`.", (Object)databaseName);
    }

    private CompletableFuture<Boolean> supplyAsyncCheckEnvironment(DataSource dataSource, ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.isPrimaryInstance(dataSource);
            }
            catch (SQLException ex) {
                throw new SQLWrapperException(ex);
            }
        }, executorService);
    }

    public boolean isPrimaryInstance(DataSource dataSource) throws SQLException {
        return !this.getReplicationInstances(dataSource).isEmpty() && this.isNotReadonlyInstance(dataSource);
    }

    /*
     * Exception decompiling
     */
    private Collection<String> getReplicationInstances(DataSource dataSource) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<String> getReplicationInstances(Statement statement) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = statement.executeQuery(SHOW_SLAVE_HOSTS);){
            while (resultSet.next()) {
                result.add(String.join((CharSequence)":", resultSet.getString("HOST"), resultSet.getString("PORT")));
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private boolean isNotReadonlyInstance(DataSource dataSource) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ReplicaDataSourceStatus loadReplicaStatus(DataSource replicaDataSource) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long queryReplicationDelayMilliseconds(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(SHOW_SLAVE_STATUS);){
            if (resultSet.next()) {
                long delay = resultSet.getLong("Seconds_Behind_Master") * 1000L;
                long l = resultSet.wasNull() ? Long.MAX_VALUE : delay;
                return l;
            }
            long l = Long.MAX_VALUE;
            return l;
        }
    }

    public String getType() {
        return "MySQL.NORMAL_REPLICATION";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

