/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.job.progress;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.task.progress.IncrementalTaskProgress;

public final class JobItemIncrementalTasksProgress {
    private final Map<String, IncrementalTaskProgress> incrementalTaskProgressMap;

    public Optional<IngestPosition<?>> getIncrementalPosition(String dataSourceName) {
        Optional<IncrementalTaskProgress> incrementalTaskProgress = this.incrementalTaskProgressMap.entrySet().stream().filter(entry -> dataSourceName.equals(entry.getKey())).map(Map.Entry::getValue).findAny();
        return incrementalTaskProgress.map(IncrementalTaskProgress::getPosition);
    }

    public String getDataSourceName() {
        return this.incrementalTaskProgressMap.keySet().stream().findAny().orElse("");
    }

    public long getIncrementalLatestActiveTimeMillis() {
        List delays = this.incrementalTaskProgressMap.values().stream().map(each -> each.getIncrementalTaskDelay().getLatestActiveTimeMillis()).collect(Collectors.toList());
        return delays.stream().reduce(Long::max).orElse(0L);
    }

    @Generated
    public JobItemIncrementalTasksProgress(Map<String, IncrementalTaskProgress> incrementalTaskProgressMap) {
        this.incrementalTaskProgressMap = incrementalTaskProgressMap;
    }

    @Generated
    public Map<String, IncrementalTaskProgress> getIncrementalTaskProgressMap() {
        return this.incrementalTaskProgressMap;
    }
}

