/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.Example;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component(value="swaggerParameterDescriptionReader")
@Order(value=-2147482648)
public class ApiParamParameterBuilder
implements ParameterBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public ApiParamParameterBuilder(DescriptionResolver descriptions, EnumTypeDeterminer enumTypeDeterminer) {
        this.descriptions = descriptions;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public void apply(ParameterContext context) {
        Optional apiParam = context.resolvedMethodParameter().findAnnotation(ApiParam.class);
        context.parameterBuilder().allowableValues(this.allowableValues(context.alternateFor(context.resolvedMethodParameter().getParameterType()), apiParam.map(ApiParam::allowableValues).orElse("")));
        if (apiParam.isPresent()) {
            ApiParam annotation = (ApiParam)apiParam.get();
            context.parameterBuilder().name((String)Optional.ofNullable(annotation.name()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null)).description((String)Optional.ofNullable(this.descriptions.resolve(annotation.value())).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null)).parameterAccess((String)Optional.ofNullable(annotation.access()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null)).defaultValue((String)Optional.ofNullable(annotation.defaultValue()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null)).allowMultiple(annotation.allowMultiple()).allowEmptyValue(Boolean.valueOf(annotation.allowEmptyValue())).required(annotation.required()).scalarExample((Object)new Example((Object)annotation.example())).complexExamples(Examples.examples(annotation.examples())).hidden(annotation.hidden()).collectionFormat(annotation.collectionFormat()).order(-2147482648);
        }
    }

    private AllowableValues allowableValues(ResolvedType parameterType, String allowableValueString) {
        AllowableValues allowableValues = null;
        if (!StringUtils.isEmpty((Object)allowableValueString)) {
            allowableValues = ApiModelProperties.allowableValueFromString(allowableValueString);
        } else {
            if (this.enumTypeDeterminer.isEnum(parameterType.getErasedType())) {
                allowableValues = Enums.allowableValues((Class)parameterType.getErasedType());
            }
            if (Collections.isContainerType((ResolvedType)parameterType)) {
                allowableValues = Enums.allowableValues((Class)Collections.collectionElementType((ResolvedType)parameterType).getErasedType());
            }
        }
        return allowableValues;
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

