/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.datasource;

import io.seata.core.model.BranchType;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.SeataDataSourceProxy;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceProxyHolder {
    private static final int MAP_INITIAL_CAPACITY = 8;
    private Map<DataSource, SeataDataSourceProxy> dataSourceProxyMap = new HashMap<DataSource, SeataDataSourceProxy>(8);

    private DataSourceProxyHolder() {
    }

    public static DataSourceProxyHolder get() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeataDataSourceProxy putDataSource(DataSource dataSource, BranchType dataSourceProxyMode) {
        DataSource originalDataSource;
        if (dataSource instanceof SeataDataSourceProxy) {
            SeataDataSourceProxy dataSourceProxy = (SeataDataSourceProxy)dataSource;
            if (dataSourceProxyMode == dataSourceProxy.getBranchType()) {
                return (SeataDataSourceProxy)dataSource;
            }
            originalDataSource = dataSourceProxy.getTargetDataSource();
        } else {
            originalDataSource = dataSource;
        }
        SeataDataSourceProxy dsProxy = this.dataSourceProxyMap.get(originalDataSource);
        if (dsProxy == null) {
            Map<DataSource, SeataDataSourceProxy> map = this.dataSourceProxyMap;
            synchronized (map) {
                dsProxy = this.dataSourceProxyMap.get(originalDataSource);
                if (dsProxy == null) {
                    dsProxy = this.createDsProxyByMode(dataSourceProxyMode, originalDataSource);
                    this.dataSourceProxyMap.put(originalDataSource, dsProxy);
                }
            }
        }
        return dsProxy;
    }

    private SeataDataSourceProxy createDsProxyByMode(BranchType mode, DataSource originDs) {
        return BranchType.XA == mode ? new DataSourceProxyXA(originDs) : new DataSourceProxy(originDs);
    }

    private static class Holder {
        private static final DataSourceProxyHolder INSTANCE = new DataSourceProxyHolder();

        private Holder() {
        }
    }
}

