/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.serial;

import java.io.Serializable;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialJavaObject;

public class SerialArray
implements Array,
Serializable {
    static final long serialVersionUID = 1L;
    private Object[] elements;
    private int baseType;
    private String baseTypeName;
    private int len;

    public SerialArray() {
    }

    public SerialArray(Array array) throws SerialException, SQLException {
        if (array == null) {
            throw new SQLException("Cannot instantiate a SerialArray object with a null Array object");
        }
        this.elements = (Object[])array.getArray();
        if (this.elements == null) {
            throw new SQLException("Invalid Array object. Calls to Array.getArray() return null value which cannot be serialized");
        }
        this.baseType = array.getBaseType();
        this.baseTypeName = array.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2004: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialBlob((Blob)this.elements[i]);
                }
                break;
            }
            case 2005: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialClob((Clob)this.elements[i]);
                }
                break;
            }
            case 70: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialDatalink((URL)this.elements[i]);
                }
                break;
            }
            case 2000: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialJavaObject(this.elements[i]);
                }
                break;
            }
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    public void setBaseTypeName(String baseTypeName) {
        this.baseTypeName = baseTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    public void setBaseType(int baseType) {
        this.baseType = baseType;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.elements;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.elements;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.elements;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.elements;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public void free() throws SQLException {
        if (this.elements != null) {
            this.elements = null;
            this.baseTypeName = null;
        }
    }

    public Object[] getElements() {
        return this.elements;
    }

    public void setElements(Object[] elements) {
        this.elements = elements;
        this.len = elements != null ? elements.length : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SerialArray) {
            SerialArray sa = (SerialArray)obj;
            return this.baseType == sa.baseType && this.baseTypeName.equals(sa.baseTypeName) && Arrays.equals(this.elements, sa.elements);
        }
        return false;
    }

    public int hashCode() {
        return (((31 + Arrays.hashCode(this.elements)) * 31 + this.len) * 31 + this.baseType) * 31 + this.baseTypeName.hashCode();
    }
}

