/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class InMemoryRetryRegistry
extends AbstractRegistry<Retry, RetryConfig>
implements RetryRegistry {
    public InMemoryRetryRegistry() {
        this(RetryConfig.ofDefaults());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, RegistryEventConsumer<Retry> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    @Override
    public Seq<Retry> getAllRetries() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public Retry retry(String name) {
        return this.retry(name, (RetryConfig)this.getDefaultConfig());
    }

    @Override
    public Retry retry(String name, RetryConfig config) {
        return (Retry)this.computeIfAbsent(name, () -> Retry.of(name, Objects.requireNonNull(config, "Config must not be null")));
    }

    @Override
    public Retry retry(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return (Retry)this.computeIfAbsent(name, () -> Retry.of(name, (RetryConfig)Objects.requireNonNull(Objects.requireNonNull(retryConfigSupplier, "Supplier must not be null").get(), "Config must not be null")));
    }

    @Override
    public Retry retry(String name, String configName) {
        return (Retry)this.computeIfAbsent(name, () -> Retry.of(name, (RetryConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
    }
}

