/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LockException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class LeaderElectorTest {
    LeaderElectorTest() {
    }

    @Test
    void runShouldAbortAfterRenewDeadlineExpired() throws Exception {
        Long renewDeadlineMillis = 1000L;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        CountDownLatch signal = new CountDownLatch(1);
        LeaderElectionConfig lec = LeaderElectorTest.mockLeaderElectionConfiguration();
        Mockito.when((Object)lec.getRenewDeadline()).thenReturn((Object)Duration.ofMillis(renewDeadlineMillis));
        Lock mockedLock = lec.getLock();
        ((Lock)Mockito.doNothing().doAnswer(invocation -> {
            Thread.sleep(renewDeadlineMillis * 2L);
            return null;
        }).when((Object)mockedLock)).update((Namespaceable)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        executor.submit(() -> {
            new LeaderElector((Namespaceable)Mockito.mock(DefaultKubernetesClient.class), lec).run();
            signal.countDown();
        });
        signal.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)signal.getCount());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).get((Namespaceable)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.times((int)1))).create((Namespaceable)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).update((Namespaceable)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.atLeast((int)1))).onNewLeader((String)ArgumentMatchers.eq((Object)"1337"));
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStartLeading();
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStopLeading();
        executor.shutdownNow();
    }

    @Test
    void runShouldEndlesslyRun() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        CountDownLatch signal = new CountDownLatch(1);
        LeaderElectionConfig lec = LeaderElectorTest.mockLeaderElectionConfiguration();
        Lock mockedLock = lec.getLock();
        ((Lock)Mockito.doNothing().doThrow(new Throwable[]{new LockException("Exception won't affect execution")}).doNothing().doAnswer(invocation -> {
            signal.countDown();
            return null;
        }).when((Object)mockedLock)).update((Namespaceable)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        executor.submit(() -> new LeaderElector((Namespaceable)Mockito.mock(DefaultKubernetesClient.class), lec).run());
        signal.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)signal.getCount());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).get((Namespaceable)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.times((int)1))).create((Namespaceable)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((Lock)Mockito.verify((Object)mockedLock, (VerificationMode)Mockito.atLeast((int)2))).update((Namespaceable)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.atLeast((int)1))).onNewLeader((String)ArgumentMatchers.eq((Object)"1337"));
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStartLeading();
        executor.shutdownNow();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        ((LeaderCallbacks)Mockito.verify((Object)lec.getLeaderCallbacks(), (VerificationMode)Mockito.times((int)1))).onStopLeading();
    }

    @Test
    void isLeaderAndIsLeaderShouldReturnTrue() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lec.getLock().identity()).thenReturn((Object)"1337");
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getHolderIdentity()).thenReturn((Object)"1337");
        boolean result = new LeaderElector((Namespaceable)Mockito.mock(DefaultKubernetesClient.class), lec).isLeader(ler);
        Assert.assertTrue((boolean)result);
    }

    @Test
    void isLeaderAndIsNotLeaderShouldReturnFalse() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lec.getLock().identity()).thenReturn((Object)"313373");
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getHolderIdentity()).thenReturn((Object)"1337");
        boolean result = new LeaderElector((Namespaceable)Mockito.mock(DefaultKubernetesClient.class), lec).isLeader(ler);
        Assert.assertFalse((boolean)result);
    }

    @Test
    void canBecomeLeaderAndDifferentLeaderWithExpiredLockShouldReturnTrue() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class);
        Mockito.when((Object)lec.getLeaseDuration()).thenReturn((Object)Duration.ofMinutes(59L));
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getRenewTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).minusHours(1L));
        boolean result = new LeaderElector((Namespaceable)Mockito.mock(DefaultKubernetesClient.class), lec).canBecomeLeader(ler);
        Assert.assertTrue((boolean)result);
    }

    @Test
    void canBecomeLeaderAndDifferentLeaderWithActiveLockShouldReturnFalse() {
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class);
        Mockito.when((Object)lec.getLeaseDuration()).thenReturn((Object)Duration.ofHours(1L));
        LeaderElectionRecord ler = (LeaderElectionRecord)Mockito.mock(LeaderElectionRecord.class);
        Mockito.when((Object)ler.getRenewTime()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC));
        boolean result = new LeaderElector((Namespaceable)Mockito.mock(DefaultKubernetesClient.class), lec).canBecomeLeader(ler);
        Assert.assertFalse((boolean)result);
    }

    @Test
    void loopCompletesOkShouldShutdownExecutorService() throws Exception {
        CountDownLatch signal = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> LeaderElector.loop(countDownLatch -> {
            countDownLatch.countDown();
            signal.countDown();
        }, (long)1L));
        signal.await(50L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)signal.getCount());
        executor.shutdownNow();
    }

    @Test
    void loopInterruptedShouldShutdownExecutorService() throws Exception {
        CountDownLatch signal = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AtomicReference<Object> loopCountDownLatch = new AtomicReference<Object>(null);
        Future<Boolean> futureLoop = executor.submit(() -> LeaderElector.loop(countDownLatch -> {
            loopCountDownLatch.set(countDownLatch);
            signal.countDown();
        }, (long)1L));
        signal.await(50L, TimeUnit.MILLISECONDS);
        futureLoop.cancel(true);
        Assert.assertEquals((long)0L, (long)signal.getCount());
        Assert.assertEquals((long)1L, (long)((CountDownLatch)loopCountDownLatch.get()).getCount());
        executor.shutdownNow();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Test
    void nowShouldReturnZonedTimeInUTC() {
        Instant now = Instant.now();
        ZonedDateTime result = LeaderElector.now();
        Assert.assertEquals((Object)ZoneOffset.UTC, (Object)result.getZone());
        long delta = result.toEpochSecond() - now.getEpochSecond();
        Assert.assertTrue((delta <= 1L ? 1 : 0) != 0);
        Assert.assertTrue((delta >= 0L ? 1 : 0) != 0);
    }

    @Test
    void jitterWithPositiveShouldReturnPositiveDouble() {
        Duration test = Duration.of(1L, ChronoUnit.SECONDS);
        Duration result = LeaderElector.jitter((Duration)test, (double)1.0);
        Assert.assertTrue((result.toMillis() < 2000L ? 1 : 0) != 0);
        Assert.assertTrue((result.toMillis() > 1000L ? 1 : 0) != 0);
    }

    @Test
    void jitterWithNegativeShouldReturnDuration() {
        Duration test = Duration.of(1L, ChronoUnit.SECONDS);
        Duration result = LeaderElector.jitter((Duration)test, (double)-1.0);
        Assert.assertTrue((result.toMillis() < 2000L ? 1 : 0) != 0);
        Assert.assertTrue((result.toMillis() > 1000L ? 1 : 0) != 0);
    }

    private static LeaderElectionConfig mockLeaderElectionConfiguration() throws Exception {
        AtomicReference<Object> activeLer = new AtomicReference<Object>(null);
        LeaderElectionConfig lec = (LeaderElectionConfig)Mockito.mock(LeaderElectionConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lec.getLeaseDuration()).thenReturn((Object)Duration.ofSeconds(2L));
        Mockito.when((Object)lec.getRenewDeadline()).thenReturn((Object)Duration.ofSeconds(1L));
        Mockito.when((Object)lec.getRetryPeriod()).thenReturn((Object)Duration.ofMillis(10L));
        Lock mockedLock = lec.getLock();
        Mockito.when((Object)mockedLock.identity()).thenReturn((Object)"1337");
        Mockito.when((Object)mockedLock.get((Namespaceable)ArgumentMatchers.any())).thenReturn(null).thenAnswer(invocation -> (LeaderElectionRecord)activeLer.get());
        ((Lock)Mockito.doAnswer(invocation -> {
            activeLer.set(invocation.getArgument(1, LeaderElectionRecord.class));
            return null;
        }).when((Object)mockedLock)).create((Namespaceable)ArgumentMatchers.any(), (LeaderElectionRecord)ArgumentMatchers.any());
        return lec;
    }
}

