/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUploadWebSocketListener;
import okhttp3.Response;
import okhttp3.WebSocket;
import okio.ByteString;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PodUploadWebSocketListenerTest {
    private PodUploadWebSocketListener podUploadWebSocketListener;

    PodUploadWebSocketListenerTest() {
    }

    @BeforeEach
    void setUp() {
        this.podUploadWebSocketListener = new PodUploadWebSocketListener();
    }

    @AfterEach
    void tearDown() {
        this.podUploadWebSocketListener = null;
    }

    @Test
    void testSendShouldTruncateAndSendFlaggedWebSocketData() {
        WebSocket mockedWebSocket = (WebSocket)Mockito.mock(WebSocket.class);
        this.podUploadWebSocketListener.onOpen(mockedWebSocket, null);
        byte[] toSend = new byte[]{1, 3, 3, 7, 0};
        this.podUploadWebSocketListener.send(toSend, 4);
        ((WebSocket)Mockito.verify((Object)mockedWebSocket, (VerificationMode)VerificationModeFactory.times((int)1))).send((ByteString)ArgumentMatchers.eq((Object)ByteString.of((byte[])new byte[]{0, 1, 3, 3, 7})));
    }

    @Test
    void testCheckErrorHasErrorFromMessageShouldThrowException() {
        this.podUploadWebSocketListener.onMessage(null, ByteString.encodeUtf8((String)"ACK"));
        this.podUploadWebSocketListener.onMessage(null, ByteString.encodeUtf8((String)"![\"I'M AN ERROR\"]"));
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podUploadWebSocketListener.checkError());
    }

    @Test
    void testCheckErrorHasErrorFromFailureShouldThrowException() {
        Response mockResponse = (Response)Mockito.mock(Response.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockResponse.code()).thenReturn((Object)1337);
        Mockito.when((Object)mockResponse.message()).thenReturn((Object)"Error");
        Mockito.when((Object)mockResponse.body().toString()).thenReturn((Object)"Detailed error description");
        this.podUploadWebSocketListener.onFailure(null, null, mockResponse);
        Assertions.assertThrows(KubernetesClientException.class, () -> this.podUploadWebSocketListener.checkError());
    }
}

