/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class MergeEnricher
extends BaseEnricher {
    public MergeEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-merge");
    }

    public void adapt(KubernetesListBuilder builder) {
        List items = Lists.notNullList((List)builder.getItems());
        HashMap kindMaps = new HashMap();
        ArrayList<HasMetadata> removeList = new ArrayList<HasMetadata>();
        for (HasMetadata item : items) {
            HasMetadata old;
            String kind = KubernetesHelper.getKind((HasMetadata)item);
            String name = KubernetesHelper.getName((HasMetadata)item);
            HashMap<String, HasMetadata> map = (HashMap<String, HasMetadata>)kindMaps.get(kind);
            if (map == null) {
                map = new HashMap<String, HasMetadata>();
                kindMaps.put(kind, map);
            }
            if ((old = (HasMetadata)map.get(name)) != null) {
                HasMetadata removeItem = this.mergeEntities(old, item);
                if (removeItem == null) continue;
                removeList.add(removeItem);
                continue;
            }
            map.put(name, item);
        }
        items.removeAll(removeList);
        builder.withItems(items);
    }

    private HasMetadata mergeEntities(HasMetadata item1, HasMetadata item2) {
        HasMetadata answer;
        if (this.isMergeEnabled() && (answer = KubernetesResourceUtil.mergeResources((HasMetadata)item1, (HasMetadata)item2, (Logger)this.log, (boolean)true)) != null) {
            return answer;
        }
        try {
            if (!this.getContext().runningWithGoal(new String[]{"fabric8:app-catalog"})) {
                this.log.warn("Duplicate resources for %s %s from %s and %s", new Object[]{KubernetesHelper.getKind((HasMetadata)item1), KubernetesHelper.getName((HasMetadata)item1), KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)item1), KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)item2)});
            }
        }
        catch (MojoExecutionException e) {
            this.log.warn("Failed to check if generated an app-catalog: %s", new Object[]{e});
        }
        return null;
    }

    protected boolean isMergeEnabled() {
        return Configs.asBoolean((String)this.getConfig(Config.enabled));
    }

    private static enum Config implements Configs.Key
    {
        enabled;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

