/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KindAndName;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Function;
import io.fabric8.utils.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public class DependencyEnricher
extends BaseEnricher {
    private static String DEPENDENCY_KUBERNETES_YAML = "META-INF/fabric8/kubernetes.yml";
    private static String DEPENDENCY_KUBERNETES_TEMPLATE_YAML = "META-INF/fabric8/k8s-template.yml";
    private static String DEPENDENCY_OPENSHIFT_YAML = "META-INF/fabric8/openshift.yml";
    private Set<URL> kubernetesDependencyArtifacts = new HashSet<URL>();
    private Set<URL> kubernetesTemplateDependencyArtifacts = new HashSet<URL>();
    private Set<URL> openshiftDependencyArtifacts = new HashSet<URL>();

    public DependencyEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-dependency");
        this.addArtifactsWithYaml(buildContext, this.kubernetesDependencyArtifacts, DEPENDENCY_KUBERNETES_YAML);
        this.addArtifactsWithYaml(buildContext, this.kubernetesTemplateDependencyArtifacts, DEPENDENCY_KUBERNETES_TEMPLATE_YAML);
        this.addArtifactsWithYaml(buildContext, this.openshiftDependencyArtifacts, DEPENDENCY_OPENSHIFT_YAML);
    }

    private void addArtifactsWithYaml(EnricherContext buildContext, Set<URL> artifactSet, String dependencyYaml) {
        Set artifacts = this.isIncludeTransitive() ? buildContext.getProject().getArtifacts() : buildContext.getProject().getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
            File file = artifact.getFile();
            try {
                URL url = new URL("jar:" + file.toURI().toURL() + "!/" + dependencyYaml);
                artifactSet.add(url);
            }
            catch (MalformedURLException e) {
                this.getLog().debug("Failed to create URL for %s: %s", new Object[]{file, e});
            }
        }
        if (this.isIncludePlugin()) {
            Enumeration<URL> resources = null;
            try {
                resources = ((Object)((Object)this)).getClass().getClassLoader().getResources(dependencyYaml);
            }
            catch (IOException e) {
                this.getLog().error("Could not find %s on the classpath: %s", new Object[]{dependencyYaml, e});
            }
            if (resources != null) {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    artifactSet.add(url);
                }
            }
        }
    }

    public void adapt(KubernetesListBuilder builder) {
        final ArrayList<HasMetadata> kubernetesItems = new ArrayList<HasMetadata>();
        this.processArtifactSetResources(this.kubernetesDependencyArtifacts, new Function<List<HasMetadata>, Void>(){

            public Void apply(List<HasMetadata> items) {
                kubernetesItems.addAll(Arrays.asList(items.toArray(new HasMetadata[items.size()])));
                return null;
            }
        });
        this.processArtifactSetResources(this.kubernetesTemplateDependencyArtifacts, new Function<List<HasMetadata>, Void>(){

            public Void apply(List<HasMetadata> items) {
                List<HasMetadata> templates = Arrays.asList(items.toArray(new HasMetadata[items.size()]));
                for (HasMetadata resource : templates) {
                    Template template;
                    List objects;
                    if (!(resource instanceof Template) || (objects = (template = (Template)resource).getObjects()) == null) continue;
                    DependencyEnricher.this.removeTemplateObjects(kubernetesItems, objects);
                    kubernetesItems.addAll(objects);
                }
                return null;
            }
        });
        this.filterAndAddItemsToBuilder(builder, kubernetesItems);
        this.processArtifactSetResources(this.openshiftDependencyArtifacts, new Function<List<HasMetadata>, Void>(){

            public Void apply(List<HasMetadata> items) {
                boolean isAppCatalog = false;
                try {
                    isAppCatalog = DependencyEnricher.this.getContext().runningWithGoal(new String[]{"fabric8:app-catalog"});
                }
                catch (MojoExecutionException e) {
                    DependencyEnricher.this.log.warn("Caught: %s", new Object[]{e});
                }
                DependencyEnricher.this.getContext().getOpenshiftDependencyResources().addOpenShiftResources(items, isAppCatalog);
                return null;
            }
        });
    }

    private void removeTemplateObjects(List<HasMetadata> list, List<HasMetadata> objects) {
        for (HasMetadata object : objects) {
            ArrayList<HasMetadata> copy = new ArrayList<HasMetadata>(list);
            for (HasMetadata resource : copy) {
                if (!Objects.equals(resource.getKind(), object.getKind()) || !Objects.equals(KubernetesHelper.getName((HasMetadata)object), KubernetesHelper.getName((HasMetadata)resource))) continue;
                list.remove(resource);
            }
        }
    }

    public void filterAndAddItemsToBuilder(KubernetesListBuilder builder, List<HasMetadata> items) {
        KindAndName aKey;
        HashMap<KindAndName, Integer> aIndexMap = new HashMap<KindAndName, Integer>();
        int nItems = 0;
        int index = 0;
        while (index < builder.getItems().size()) {
            HasMetadata aItem = (HasMetadata)builder.getItems().get(index);
            aKey = new KindAndName(aItem);
            aIndexMap.put(aKey, index);
            ++index;
            ++nItems;
        }
        for (HasMetadata item : items) {
            aKey = new KindAndName(item);
            if (aIndexMap.containsKey(aKey)) {
                HasMetadata duplicateItem = (HasMetadata)builder.getItems().get((Integer)aIndexMap.get(aKey));
                item = KubernetesResourceUtil.mergeResources((HasMetadata)item, (HasMetadata)duplicateItem, (Logger)this.log, (boolean)false);
                builder.setToItems(((Integer)aIndexMap.get(aKey)).intValue(), item);
                continue;
            }
            aIndexMap.put(aKey, nItems++);
            builder.addToItems(new HasMetadata[]{item});
        }
    }

    private void processArtifactSetResources(Set<URL> artifactSet, Function<List<HasMetadata>, Void> function) {
        for (URL url : artifactSet) {
            try {
                Template template;
                InputStream is = url.openStream();
                if (is == null) continue;
                this.log.debug("Processing Kubernetes YAML in at: %s", new Object[]{url});
                KubernetesList resources = (KubernetesList)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(is, KubernetesList.class);
                List items = Lists.notNullList((List)resources.getItems());
                if (items.size() == 0 && Objects.equals("Template", resources.getKind()) && (template = (Template)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(is = url.openStream(), Template.class)) != null) {
                    items.add(template);
                }
                for (HasMetadata item : items) {
                    KubernetesResourceUtil.setSourceUrlAnnotationIfNotSet((HasMetadata)item, (String)url.toString());
                    this.log.debug("  found %s  %s", new Object[]{KubernetesHelper.getKind((HasMetadata)item), KubernetesHelper.getName((HasMetadata)item)});
                }
                function.apply((Object)items);
            }
            catch (IOException e) {
                this.getLog().debug("Skipping %s: %s", new Object[]{url, e});
            }
        }
    }

    protected boolean isIncludePlugin() {
        return Configs.asBoolean((String)this.getConfig(Config.includePlugin));
    }

    protected boolean isIncludeTransitive() {
        return Configs.asBoolean((String)this.getConfig(Config.includeTransitive));
    }

    private static enum Config implements Configs.Key
    {
        includeTransitive{
            {
                this.d = "true";
            }
        }
        ,
        includePlugin{
            {
                this.d = "true";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

