/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Job;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecFluent;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.DaemonSetHandler;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.JobHandler;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.StatefulSetHandler;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Lists;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class DefaultControllerEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig", "StatefulSet", "DaemonSet", "Job"};
    private final DeploymentHandler deployHandler;
    private final ReplicationControllerHandler rcHandler;
    private final ReplicaSetHandler rsHandler;
    private final StatefulSetHandler statefulSetHandler;
    private final DaemonSetHandler daemonSetHandler;
    private final JobHandler jobHandler;

    public DefaultControllerEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-controller");
        HandlerHub handlers = new HandlerHub(buildContext.getProject());
        this.rcHandler = handlers.getReplicationControllerHandler();
        this.rsHandler = handlers.getReplicaSetHandler();
        this.deployHandler = handlers.getDeploymentHandler();
        this.statefulSetHandler = handlers.getStatefulSetHandler();
        this.daemonSetHandler = handlers.getDaemonSetHandler();
        this.jobHandler = handlers.getJobHandler();
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        final String name = this.getConfig(Config.name, MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0]));
        ResourceConfig config = new ResourceConfig.Builder().controllerName(name).imagePullPolicy(this.getConfig(Config.pullPolicy)).withReplicas(Configs.asInt((String)this.getConfig(Config.replicaCount))).build();
        List images = this.getImages();
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])POD_CONTROLLER_KINDS)) {
            if (!Lists.isNullOrEmpty((List)images)) {
                String type = this.getConfig(Config.type);
                if ("deployment".equalsIgnoreCase(type)) {
                    this.log.info("Adding a default Deployment", new Object[0]);
                    builder.addToDeploymentItems(new Deployment[]{this.deployHandler.getDeployment(config, images)});
                } else if ("statefulSet".equalsIgnoreCase(type)) {
                    this.log.info("Adding a default StatefulSet", new Object[0]);
                    builder.addToStatefulSetItems(new StatefulSet[]{this.statefulSetHandler.getStatefulSet(config, images)});
                } else if ("daemonSet".equalsIgnoreCase(type)) {
                    this.log.info("Adding a default DaemonSet", new Object[0]);
                    builder.addToDaemonSetItems(new DaemonSet[]{this.daemonSetHandler.getDaemonSet(config, images)});
                } else if ("replicaSet".equalsIgnoreCase(type)) {
                    this.log.info("Adding a default ReplicaSet", new Object[0]);
                    builder.addToReplicaSetItems(new ReplicaSet[]{this.rsHandler.getReplicaSet(config, images)});
                } else if ("replicationController".equalsIgnoreCase(type)) {
                    this.log.info("Adding a default ReplicationController", new Object[0]);
                    builder.addToReplicationControllerItems(new ReplicationController[]{this.rcHandler.getReplicationController(config, images)});
                } else if ("job".equalsIgnoreCase(type)) {
                    this.log.info("Adding a default Job", new Object[0]);
                    builder.addToJobItems(new Job[]{this.jobHandler.getJob(config, images)});
                }
            }
        } else if (KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])new String[]{"StatefulSet"})) {
            final StatefulSetSpec spec = this.statefulSetHandler.getStatefulSet(config, images).getSpec();
            if (spec != null) {
                builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

                    public void visit(StatefulSetBuilder statefulSetBuilder) {
                        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)statefulSetBuilder.editOrNewSpec().editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate()).endSpec();
                        DefaultControllerEnricher.this.mergeStatefulSetSpec(statefulSetBuilder, spec);
                    }
                });
                if (spec.getTemplate() != null && spec.getTemplate().getSpec() != null) {
                    final PodSpec podSpec = spec.getTemplate().getSpec();
                    builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

                        public void visit(PodSpecBuilder builder) {
                            KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)builder, (PodSpec)podSpec, (String)name);
                        }
                    });
                }
            }
        } else {
            final DeploymentSpec spec = this.deployHandler.getDeployment(config, images).getSpec();
            if (spec != null) {
                builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

                    public void visit(DeploymentBuilder deploymentBuilder) {
                        ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)deploymentBuilder.editOrNewSpec().editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate()).endSpec();
                        DefaultControllerEnricher.this.mergeDeploymentSpec(deploymentBuilder, spec);
                    }
                });
                if (spec.getTemplate() != null && spec.getTemplate().getSpec() != null) {
                    final PodSpec podSpec = spec.getTemplate().getSpec();
                    builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

                        public void visit(PodSpecBuilder builder) {
                            KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)builder, (PodSpec)podSpec, (String)name);
                        }
                    });
                }
            }
        }
    }

    private void mergeDeploymentSpec(DeploymentBuilder builder, DeploymentSpec spec) {
        DeploymentFluent.SpecNested specBuilder = builder.editSpec();
        KubernetesResourceUtil.mergeSimpleFields((Object)specBuilder, (Object)spec);
        specBuilder.endSpec();
    }

    private void mergeStatefulSetSpec(StatefulSetBuilder builder, StatefulSetSpec spec) {
        StatefulSetFluent.SpecNested specBuilder = builder.editSpec();
        KubernetesResourceUtil.mergeSimpleFields((Object)specBuilder, (Object)spec);
        specBuilder.endSpec();
    }

    static {
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(String.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Double.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Float.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Long.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Integer.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Short.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Character.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Byte.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Double.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Float.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Long.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Integer.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Short.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Character.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Byte.TYPE);
    }

    private static enum Config implements Configs.Key
    {
        name,
        pullPolicy{
            {
                this.d = "IfNotPresent";
            }
        }
        ,
        type{
            {
                this.d = "deployment";
            }
        }
        ,
        replicaCount{
            {
                this.d = "1";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

