/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import reactor.core.publisher.Mono;

public class MailNotifier
extends AbstractStatusChangeNotifier {
    private final JavaMailSender mailSender;
    private final TemplateEngine templateEngine;
    private String[] to = new String[]{"root@localhost"};
    private String[] cc = new String[0];
    private String from = "Spring Boot Admin <noreply@localhost>";
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @Nullable
    private String baseUrl;
    private String template = "classpath:/META-INF/spring-boot-admin-server/mail/status-changed.html";

    public MailNotifier(JavaMailSender mailSender, InstanceRepository repository, TemplateEngine templateEngine) {
        super(repository);
        this.mailSender = mailSender;
        this.templateEngine = templateEngine;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> {
            Context ctx = new Context();
            ctx.setVariables(this.additionalProperties);
            ctx.setVariable("baseUrl", (Object)this.baseUrl);
            ctx.setVariable("event", (Object)event);
            ctx.setVariable("instance", (Object)instance);
            ctx.setVariable("lastStatus", (Object)this.getLastStatus(event.getInstance()));
            try {
                MimeMessage mimeMessage = this.mailSender.createMimeMessage();
                MimeMessageHelper message = new MimeMessageHelper(mimeMessage, StandardCharsets.UTF_8.name());
                message.setText(this.getBody(ctx).replaceAll("\\s+\\n", "\n"), true);
                message.setSubject(this.getSubject(ctx));
                message.setTo(this.to);
                message.setCc(this.cc);
                message.setFrom(this.from);
                this.mailSender.send(mimeMessage);
            }
            catch (MessagingException ex) {
                throw new RuntimeException("Error sending mail notification", ex);
            }
        });
    }

    protected String getBody(Context ctx) {
        return this.templateEngine.process(this.template, (IContext)ctx);
    }

    protected String getSubject(Context ctx) {
        return this.templateEngine.process(this.template, Collections.singleton("subject"), (IContext)ctx).trim();
    }

    public void setTo(String[] to) {
        this.to = Arrays.copyOf(to, to.length);
    }

    public String[] getTo() {
        return Arrays.copyOf(this.to, this.to.length);
    }

    public void setCc(String[] cc) {
        this.cc = Arrays.copyOf(cc, cc.length);
    }

    public String[] getCc() {
        return Arrays.copyOf(this.cc, this.cc.length);
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Nullable
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(@Nullable String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

