/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pos;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.segment.plugins.pos.POSPerceptronFeature;
import com.mayabot.nlp.utils.Characters;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019H\u0007J6\u0010\u001a\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007JP\u0010\u001c\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u001d2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\u001b\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptronFeature;", "", "()V", "CHAR_BEGIN", "", "CHAR_END", "s2s", "Ljava/util/function/Function;", "getS2s", "()Ljava/util/function/Function;", "addFeature", "", "features", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "vector", "Lcom/mayabot/nlp/hppc/IntArrayList;", "stringBuilder", "Lcom/mayabot/nlp/common/FastStringBuilder;", "extractFeature", "sentence", "", "size", "", "position", "callBack", "Ljava/util/function/Consumer;", "extractFeatureVector", "buffer", "extractFeatureVector2", "T", "sink", "mynlp-segment"})
public final class POSPerceptronFeature {
    private static final String CHAR_BEGIN = "_B_";
    private static final String CHAR_END = "_E_";
    @NotNull
    private static final Function<String, String> s2s;
    public static final POSPerceptronFeature INSTANCE;

    @JvmStatic
    public static final void extractFeature(@NotNull List<String> sentence, int size, int position, @NotNull Consumer<String> callBack) {
        char c;
        boolean isP;
        String nextWord;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull(callBack, (String)"callBack");
        String preWord = position > 0 ? sentence.get(position - 1) : CHAR_BEGIN;
        String curWord = sentence.get(position);
        String string = nextWord = position < size - 1 ? sentence.get(position + 1) : CHAR_END;
        if (nextWord.length() == 1 && ((isP = Characters.isPunctuation((char)(c = nextWord.charAt(0)))) || c == ' ')) {
            nextWord = "XPU";
        }
        if (preWord.length() == 1 && ((isP = Characters.isPunctuation((char)(c = preWord.charAt(0)))) || c == ' ')) {
            preWord = "XPU";
        }
        callBack.accept(preWord + '\u263a');
        callBack.accept(curWord);
        callBack.accept(nextWord + '\u2642');
        int length = curWord.length();
        if (length >= 2) {
            int last = length - 1;
            char c1 = curWord.charAt(0);
            char l1 = curWord.charAt(last);
            callBack.accept("" + c1 + '\u2605');
            callBack.accept("" + l1 + '\u2706');
            if (length >= 3) {
                char c2 = curWord.charAt(1);
                char l2 = curWord.charAt(last - 1);
                callBack.accept("" + c1 + c2 + '\u2605');
                callBack.accept("" + l1 + l2 + '\u2706');
                if (length >= 4) {
                    char c3 = curWord.charAt(2);
                    char l3 = curWord.charAt(last - 2);
                    callBack.accept("" + c1 + c2 + c3 + '\u2605');
                    callBack.accept("" + l1 + l2 + l3 + '\u2706');
                }
            }
        }
    }

    @NotNull
    public final Function<String, String> getS2s() {
        return s2s;
    }

    @JvmStatic
    @NotNull
    public static final IntArrayList extractFeatureVector(@NotNull List<String> sentence, int size, int position, @NotNull FeatureSet features, @NotNull FastStringBuilder buffer) {
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)features, (String)"features");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        return POSPerceptronFeature.extractFeatureVector2(sentence, size, position, features, s2s, buffer);
    }

    @JvmStatic
    @NotNull
    public static final <T> IntArrayList extractFeatureVector2(@NotNull List<? extends T> sentence, int size, int position, @NotNull FeatureSet features, @NotNull Function<T, String> sink, @NotNull FastStringBuilder buffer) {
        char c;
        boolean isP;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)features, (String)"features");
        Intrinsics.checkParameterIsNotNull(sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        IntArrayList vector = new IntArrayList(11);
        buffer.clear();
        String string = position > 0 ? sink.apply(sentence.get(position - 1)) : CHAR_BEGIN;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (position > 0) sink.a\u2026ion - 1]) else CHAR_BEGIN");
        String preWord = string;
        String string2 = sink.apply(sentence.get(position));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sink.apply(sentence[position])");
        String curWord = string2;
        String string3 = position < size - 1 ? sink.apply(sentence.get(position + 1)) : CHAR_END;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"if (position < size - 1)\u2026ition + 1]) else CHAR_END");
        String nextWord = string3;
        if (nextWord.length() == 1 && ((isP = Characters.isPunctuation((char)(c = nextWord.charAt(0)))) || c == ' ')) {
            nextWord = "XPU";
        }
        if (preWord.length() == 1 && ((isP = Characters.isPunctuation((char)(c = preWord.charAt(0)))) || c == ' ')) {
            preWord = "XPU";
        }
        buffer.append(preWord);
        buffer.append('\u263a');
        INSTANCE.addFeature(features, vector, buffer);
        int id = features.featureId(curWord);
        if (id >= 0) {
            vector.add(id);
            vector.add(id);
        }
        buffer.append(nextWord);
        buffer.append('\u2642');
        INSTANCE.addFeature(features, vector, buffer);
        int length = curWord.length();
        if (length >= 2) {
            int last = length - 1;
            char c1 = curWord.charAt(0);
            char l1 = curWord.charAt(last);
            buffer.set2(c1, '\u2605');
            INSTANCE.addFeature(features, vector, buffer);
            buffer.set2(l1, '\u2706');
            INSTANCE.addFeature(features, vector, buffer);
            if (length >= 3) {
                char c2 = curWord.charAt(1);
                char l2 = curWord.charAt(last - 1);
                buffer.set3(c1, c2, '\u2605');
                INSTANCE.addFeature(features, vector, buffer);
                buffer.set3(l1, l2, '\u2706');
                INSTANCE.addFeature(features, vector, buffer);
                if (length >= 4) {
                    char c3 = curWord.charAt(2);
                    char l3 = curWord.charAt(last - 2);
                    buffer.set4(c1, c2, c3, '\u2605');
                    INSTANCE.addFeature(features, vector, buffer);
                    buffer.set4(l1, l2, l3, '\u2706');
                    INSTANCE.addFeature(features, vector, buffer);
                }
            }
        }
        vector.add(0);
        return vector;
    }

    private final void addFeature(FeatureSet features, IntArrayList vector, FastStringBuilder stringBuilder) {
        int id = features.featureId((CharSequence)stringBuilder);
        stringBuilder.clear();
        if (id >= 0) {
            vector.add(id);
        }
    }

    private POSPerceptronFeature() {
    }

    static {
        POSPerceptronFeature pOSPerceptronFeature;
        INSTANCE = pOSPerceptronFeature = new POSPerceptronFeature();
        s2s = s2s.1.INSTANCE;
    }
}

