/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.ncache.CacheEntry;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Optional;

class LastModifiedTimeMetadata {
    static Blob generateMetadata(ImmutableList<LayerEntry> layerEntries) throws IOException {
        return Blobs.from(LastModifiedTimeMetadata.getLastModifiedTime(layerEntries).toInstant().toString());
    }

    static FileTime getLastModifiedTime(ImmutableList<LayerEntry> layerEntries) throws IOException {
        FileTime maxLastModifiedTime = FileTime.from(Instant.MIN);
        for (LayerEntry layerEntry : layerEntries) {
            FileTime lastModifiedTime = Files.getLastModifiedTime(layerEntry.getSourceFile(), new LinkOption[0]);
            if (lastModifiedTime.compareTo(maxLastModifiedTime) <= 0) continue;
            maxLastModifiedTime = lastModifiedTime;
        }
        return maxLastModifiedTime;
    }

    static Optional<FileTime> getLastModifiedTime(CacheEntry cacheEntry) throws IOException {
        if (!cacheEntry.getMetadataBlob().isPresent()) {
            return Optional.empty();
        }
        Blob metadataBlob = cacheEntry.getMetadataBlob().get();
        return Optional.of(FileTime.from(Instant.parse(Blobs.writeToString(metadataBlob))));
    }

    private LastModifiedTimeMetadata() {
    }
}

