/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.HttpHeaders;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import java.util.List;
import javax.annotation.Nullable;

public class Request {
    private final HttpHeaders headers;
    @Nullable
    private final BlobHttpContent body;
    @Nullable
    private final Integer httpTimeout;

    public static Builder builder() {
        return new Builder();
    }

    private Request(Builder builder) {
        this.headers = builder.headers;
        this.body = builder.body;
        this.httpTimeout = builder.httpTimeout;
    }

    HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nullable
    BlobHttpContent getHttpContent() {
        return this.body;
    }

    @Nullable
    Integer getHttpTimeout() {
        return this.httpTimeout;
    }

    public static class Builder {
        private final HttpHeaders headers = new HttpHeaders().setAccept("*/*");
        @Nullable
        private BlobHttpContent body;
        @Nullable
        private Integer httpTimeout;

        public Request build() {
            return new Request(this);
        }

        public Builder setAuthorization(@Nullable Authorization authorization) {
            if (authorization != null) {
                this.headers.setAuthorization(authorization.toString());
            }
            return this;
        }

        public Builder setAccept(List<String> mimeTypes) {
            this.headers.setAccept(String.join((CharSequence)",", mimeTypes));
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.headers.setUserAgent(userAgent);
            return this;
        }

        public Builder setHttpTimeout(@Nullable Integer httpTimeout) {
            this.httpTimeout = httpTimeout;
            return this;
        }

        public Builder setBody(@Nullable BlobHttpContent blobHttpContent) {
            this.body = blobHttpContent;
            return this;
        }
    }
}

