/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.time.LocalTime;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.DateConvertor;

public final class LocalTimeConvertor
implements Convertor<LocalTime> {
    public static final LocalTimeConvertor INSTANCE = new LocalTimeConvertor();

    @Override
    public LocalTime convert(String value) {
        if (value == null) {
            return null;
        }
        long milliseconds = DateConvertor.toMilliseconds(value, LocalTime.class);
        return LocalTimeConvertor.convertToLocalTime(milliseconds);
    }

    @Override
    public LocalTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        long milliseconds = DateConvertor.toMilliseconds(value, LocalTime.class);
        return LocalTimeConvertor.convertToLocalTime(milliseconds);
    }

    private static LocalTime convertToLocalTime(long milliseconds) {
        long ms = Math.floorMod(milliseconds, 86400000L);
        return LocalTime.ofNanoOfDay(ms * 1000L * 1000L);
    }
}

