/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import jetbrick.util.JdkUtils;

public class JdkReflectionUtils {
    public static boolean CAN_CONTROL_MEMBER_ACCESSIBLE = JdkReflectionUtils.canControlMemberAccessible();

    public static void setAccessible(AccessibleObject accessibleObject) {
        if (JdkUtils.JAVA_MAJOR_VERSION < 9) {
            try {
                if (!accessibleObject.isAccessible()) {
                    accessibleObject.setAccessible(true);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static Object get(Field field, Object obj) throws IllegalArgumentException, IllegalAccessException {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            if (CAN_CONTROL_MEMBER_ACCESSIBLE) {
                field.setAccessible(true);
                return field.get(obj);
            }
            throw e;
        }
    }

    public static void set(Field field, Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            if (CAN_CONTROL_MEMBER_ACCESSIBLE) {
                field.setAccessible(true);
                field.set(obj, value);
            }
            throw e;
        }
    }

    public static Object invoke(Method method, Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            if (CAN_CONTROL_MEMBER_ACCESSIBLE) {
                method.setAccessible(true);
                return method.invoke(obj, args);
            }
            throw e;
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... initargs) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            return constructor.newInstance(initargs);
        }
        catch (IllegalAccessException e) {
            if (CAN_CONTROL_MEMBER_ACCESSIBLE) {
                constructor.setAccessible(true);
                return constructor.newInstance(initargs);
            }
            throw e;
        }
    }

    private static boolean canControlMemberAccessible() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }
}

