/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import jetbrick.bean.Getter;
import jetbrick.bean.JdkReflectionUtils;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.Setter;
import jetbrick.bean.TypeResolverUtils;
import jetbrick.bean.asm.AsmAccessor;
import jetbrick.util.ExceptionUtils;

public final class FieldInfo
implements Comparable<FieldInfo>,
Getter,
Setter {
    private final KlassInfo declaringKlass;
    private final Field field;
    private final int offset;

    public static FieldInfo create(Field field) {
        KlassInfo klass = KlassInfo.create(field.getDeclaringClass());
        return klass.getDeclaredField(field);
    }

    protected FieldInfo(KlassInfo declaringKlass, Field field, int offset) {
        this.declaringKlass = declaringKlass;
        this.field = field;
        this.offset = offset;
        JdkReflectionUtils.setAccessible(field);
    }

    public KlassInfo getDeclaringKlass() {
        return this.declaringKlass;
    }

    public String getName() {
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public int getOffset() {
        return this.offset;
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public Class<?> getRawType(KlassInfo declaringKlass) {
        return this.getRawType(declaringKlass.getType());
    }

    public Class<?> getRawType(Class<?> declaringClass) {
        return TypeResolverUtils.getRawType(this.field.getGenericType(), declaringClass);
    }

    public Class<?> getRawComponentType(Class<?> declaringClass, int componentIndex) {
        return TypeResolverUtils.getComponentType(this.field.getGenericType(), declaringClass, componentIndex);
    }

    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    public int getModifiers() {
        return this.field.getModifiers();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    @Override
    public Object get(Object object) {
        AsmAccessor accessor = this.declaringKlass.getAsmAccessor();
        if (accessor == null) {
            try {
                return JdkReflectionUtils.get(this.field, object);
            }
            catch (Exception e) {
                throw ExceptionUtils.unchecked(e);
            }
        }
        return accessor.getField(object, this.offset);
    }

    @Override
    public void set(Object object, Object value) {
        AsmAccessor accessor = this.declaringKlass.getAsmAccessor();
        if (accessor == null) {
            try {
                JdkReflectionUtils.set(this.field, object, value);
            }
            catch (Exception e) {
                throw ExceptionUtils.unchecked(e);
            }
        } else {
            accessor.setField(object, this.offset, value);
        }
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.field.getName().compareTo(o.field.getName());
    }

    public String toString() {
        return this.field.toString();
    }
}

