/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import jetbrick.bean.Creater;
import jetbrick.bean.Executable;
import jetbrick.bean.JdkReflectionUtils;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.asm.AsmAccessor;
import jetbrick.util.ExceptionUtils;

public final class ConstructorInfo
extends Executable
implements Creater,
Comparable<ConstructorInfo> {
    private final KlassInfo declaringKlass;
    private final Constructor<?> constructor;
    private final int offset;

    public static ConstructorInfo create(Constructor<?> constructor) {
        KlassInfo klass = KlassInfo.create(constructor.getDeclaringClass());
        return klass.getDeclaredConstructor(constructor);
    }

    protected ConstructorInfo(KlassInfo declaringKlass, Constructor<?> constructor, int offset) {
        this.declaringKlass = declaringKlass;
        this.constructor = constructor;
        this.offset = offset;
        JdkReflectionUtils.setAccessible(constructor);
    }

    @Override
    public KlassInfo getDeclaringKlass() {
        return this.declaringKlass;
    }

    @Override
    public String getName() {
        return "<init>";
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getParameterCount() {
        return this.constructor.getParameterTypes().length;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.constructor.getParameterTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    public boolean isDefault() {
        return this.constructor.getParameterTypes().length == 0;
    }

    @Override
    public boolean isVarArgs() {
        return this.constructor.isVarArgs();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.constructor.getAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.constructor.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.constructor.isAnnotationPresent(annotationClass);
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.constructor.getParameterAnnotations();
    }

    @Override
    public int getModifiers() {
        return this.constructor.getModifiers();
    }

    @Override
    public Object newInstance(Object ... args) {
        AsmAccessor accessor = this.declaringKlass.getAsmAccessor();
        if (accessor == null) {
            try {
                return JdkReflectionUtils.newInstance(this.constructor, args);
            }
            catch (Exception e) {
                throw ExceptionUtils.unchecked(e);
            }
        }
        return accessor.newInstance(this.offset, args);
    }

    @Override
    public int compareTo(ConstructorInfo o) {
        return this.getSignature().compareTo(o.getSignature());
    }
}

